/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static final short LITTLE_ENDIAN = 18761;
    public static final short BIG_ENDIAN = 19789;

    public static void close(InputStream is) throws IOException {
        is.close();
    }

    public static void close(OutputStream os) throws IOException {
        os.close();
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = is.read(buf)) != -1) {
            bout.write(buf, 0, len);
        }
        is.close();
        bout.close();
        return bout.toByteArray();
    }

    public static int read(InputStream is) throws IOException {
        return is.read();
    }

    public static int read(InputStream is, byte[] bytes) throws IOException {
        return is.read(bytes);
    }

    public static int read(InputStream is, byte[] bytes, int off, int len) throws IOException {
        return is.read(bytes, off, len);
    }

    public static double readDouble(InputStream is) throws IOException {
        return Double.longBitsToDouble(IOUtils.readLong(is));
    }

    public static double readDoubleMM(InputStream is) throws IOException {
        return Double.longBitsToDouble(IOUtils.readLongMM(is));
    }

    public static float readFloat(InputStream is) throws IOException {
        return Float.intBitsToFloat(IOUtils.readInt(is));
    }

    public static float readFloatMM(InputStream is) throws IOException {
        return Float.intBitsToFloat(IOUtils.readIntMM(is));
    }

    public static byte[] readFully(InputStream is, int bufLen) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(bufLen);
        byte[] buf = new byte[bufLen];
        int count = is.read(buf);
        while (count > 0) {
            bout.write(buf, 0, count);
            count = is.read(buf);
        }
        return bout.toByteArray();
    }

    public static void readFully(InputStream is, byte[] b) throws IOException {
        IOUtils.readFully(is, b, 0, b.length);
    }

    public static void readFully(InputStream is, byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = is.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static int readInt(byte[] buf, int start_idx) {
        return buf[start_idx++] & 0xFF | (buf[start_idx++] & 0xFF) << 8 | (buf[start_idx++] & 0xFF) << 16 | (buf[start_idx++] & 0xFF) << 24;
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        return (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    public static int readIntMM(byte[] buf, int start_idx) {
        return (buf[start_idx++] & 0xFF) << 24 | (buf[start_idx++] & 0xFF) << 16 | (buf[start_idx++] & 0xFF) << 8 | buf[start_idx++] & 0xFF;
    }

    public static int readIntMM(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    public static long readLong(byte[] buf, int start_idx) {
        return (long)buf[start_idx++] & 0xFFL | (((long)buf[start_idx++] & 0xFFL) << 8 | ((long)buf[start_idx++] & 0xFFL) << 16 | ((long)buf[start_idx++] & 0xFFL) << 24 | ((long)buf[start_idx++] & 0xFFL) << 32 | ((long)buf[start_idx++] & 0xFFL) << 40 | ((long)buf[start_idx++] & 0xFFL) << 48 | ((long)buf[start_idx] & 0xFFL) << 56);
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        IOUtils.readFully(is, buf);
        return ((long)buf[7] & 0xFFL) << 56 | ((long)buf[6] & 0xFFL) << 48 | ((long)buf[5] & 0xFFL) << 40 | ((long)buf[4] & 0xFFL) << 32 | ((long)buf[3] & 0xFFL) << 24 | ((long)buf[2] & 0xFFL) << 16 | ((long)buf[1] & 0xFFL) << 8 | (long)buf[0] & 0xFFL;
    }

    public static long readLongMM(byte[] buf, int start_idx) {
        return ((long)buf[start_idx++] & 0xFFL) << 56 | ((long)buf[start_idx++] & 0xFFL) << 48 | ((long)buf[start_idx++] & 0xFFL) << 40 | ((long)buf[start_idx++] & 0xFFL) << 32 | ((long)buf[start_idx++] & 0xFFL) << 24 | ((long)buf[start_idx++] & 0xFFL) << 16 | ((long)buf[start_idx++] & 0xFFL) << 8 | (long)buf[start_idx] & 0xFFL;
    }

    public static long readLongMM(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        IOUtils.readFully(is, buf);
        return ((long)buf[0] & 0xFFL) << 56 | ((long)buf[1] & 0xFFL) << 48 | ((long)buf[2] & 0xFFL) << 40 | ((long)buf[3] & 0xFFL) << 32 | ((long)buf[4] & 0xFFL) << 24 | ((long)buf[5] & 0xFFL) << 16 | ((long)buf[6] & 0xFFL) << 8 | (long)buf[7] & 0xFFL;
    }

    public static float readS15Fixed16MMNumber(byte[] buf, int start_idx) {
        short s15 = (short)((buf[start_idx++] & 0xFF) << 8 | buf[start_idx++] & 0xFF);
        int fixed16 = (buf[start_idx++] & 0xFF) << 8 | buf[start_idx] & 0xFF;
        return (float)s15 + (float)fixed16 / 65536.0f;
    }

    public static float readS15Fixed16MMNumber(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        short s15 = (short)(buf[1] & 0xFF | (buf[0] & 0xFF) << 8);
        int fixed16 = buf[3] & 0xFF | (buf[2] & 0xFF) << 8;
        return (float)s15 + (float)fixed16 / 65536.0f;
    }

    public static float readS15Fixed16Number(byte[] buf, int start_idx) {
        short s15 = (short)(buf[start_idx++] & 0xFF | (buf[start_idx++] & 0xFF) << 8);
        int fixed16 = buf[start_idx++] & 0xFF | (buf[start_idx] & 0xFF) << 8;
        return (float)s15 + (float)fixed16 / 65536.0f;
    }

    public static float readS15Fixed16Number(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        short s15 = (short)(buf[0] & 0xFF | (buf[1] & 0xFF) << 8);
        int fixed16 = buf[2] & 0xFF | (buf[3] & 0xFF) << 8;
        return (float)s15 + (float)fixed16 / 65536.0f;
    }

    public static short readShort(byte[] buf, int start_idx) {
        return (short)(buf[start_idx++] & 0xFF | (buf[start_idx] & 0xFF) << 8);
    }

    public static short readShort(InputStream is) throws IOException {
        byte[] buf = new byte[2];
        IOUtils.readFully(is, buf);
        return (short)((buf[1] & 0xFF) << 8 | buf[0] & 0xFF);
    }

    public static short readShortMM(byte[] buf, int start_idx) {
        return (short)((buf[start_idx++] & 0xFF) << 8 | buf[start_idx] & 0xFF);
    }

    public static short readShortMM(InputStream is) throws IOException {
        byte[] buf = new byte[2];
        IOUtils.readFully(is, buf);
        return (short)((buf[0] & 0xFF) << 8 | buf[1] & 0xFF);
    }

    public static long readUnsignedInt(byte[] buf, int start_idx) {
        return (long)(buf[start_idx++] & 0xFF | (buf[start_idx++] & 0xFF) << 8 | (buf[start_idx++] & 0xFF) << 16 | (buf[start_idx++] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static long readUnsignedInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        return (long)((buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUnsignedIntMM(byte[] buf, int start_idx) {
        return (long)IOUtils.readIntMM(buf, start_idx) & 0xFFFFFFFFL;
    }

    public static long readUnsignedIntMM(InputStream is) throws IOException {
        return (long)IOUtils.readIntMM(is) & 0xFFFFFFFFL;
    }

    public static int readUnsignedShort(byte[] buf, int start_idx) {
        return buf[start_idx++] & 0xFF | (buf[start_idx] & 0xFF) << 8;
    }

    public static int readUnsignedShort(InputStream is) throws IOException {
        byte[] buf = new byte[2];
        IOUtils.readFully(is, buf);
        return (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    public static int readUnsignedShortMM(byte[] buf, int start_idx) {
        return (buf[start_idx++] & 0xFF) << 8 | buf[start_idx] & 0xFF;
    }

    public static int readUnsignedShortMM(InputStream is) throws IOException {
        byte[] buf = new byte[2];
        IOUtils.readFully(is, buf);
        return (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
    }

    public static long skip(InputStream is, long len) throws IOException {
        return is.skip(len);
    }

    public static void skipFully(InputStream is, int n) throws IOException {
        IOUtils.readFully(is, new byte[n]);
    }

    public static void write(OutputStream os, byte[] bytes) throws IOException {
        os.write(bytes);
    }

    public static void write(OutputStream os, byte[] bytes, int off, int len) throws IOException {
        os.write(bytes, off, len);
    }

    public static void write(OutputStream os, int abyte) throws IOException {
        os.write(abyte);
    }

    public static void writeInt(OutputStream os, int value) throws IOException {
        os.write(new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24)});
    }

    public static void writeIntMM(OutputStream os, int value) throws IOException {
        os.write(new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value});
    }

    public static void writeLong(OutputStream os, long value) throws IOException {
        os.write(new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24), (byte)(value >>> 32), (byte)(value >>> 40), (byte)(value >>> 48), (byte)(value >>> 56)});
    }

    public static void writeLongMM(OutputStream os, long value) throws IOException {
        os.write(new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value});
    }

    public static void writeShort(OutputStream os, int value) throws IOException {
        os.write(new byte[]{(byte)value, (byte)(value >>> 8)});
    }

    public static void writeShortMM(OutputStream os, int value) throws IOException {
        os.write(new byte[]{(byte)(value >>> 8), (byte)value});
    }

    private IOUtils() {
    }
}

