/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.RandomAccessInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MemoryCacheRandomAccessInputStream
extends RandomAccessInputStream {
    private static final int BUFFER_SHIFT = 12;
    private static final int BUFFER_SIZE = 4096;
    private static final int BUFFER_MASK = 4095;
    private long pointer = 0L;
    private List<byte[]> cache = new ArrayList<byte[]>(10);
    private int length = 0;
    private boolean foundEOS = false;

    public MemoryCacheRandomAccessInputStream(InputStream src) {
        super(src);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.cache.clear();
        this.cache = null;
        this.src.close();
        this.src = null;
        this.closed = true;
    }

    @Override
    public void shallowClose() {
        if (this.closed) {
            return;
        }
        this.cache.clear();
        this.cache = null;
        this.src = null;
        this.closed = true;
    }

    @Override
    public long getStreamPointer() {
        return this.pointer;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        long l = this.pointer + 1L;
        long pos = this.readUntil(l);
        if (pos >= l) {
            byte[] buf = this.cache.get((int)(this.pointer >> 12));
            return buf[(int)(this.pointer++ & 0xFFFL)] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        this.ensureOpen();
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)len);
        if (l <= this.pointer) {
            return -1;
        }
        byte[] buf = this.cache.get((int)(this.pointer >> 12));
        int k = Math.min(len, 4096 - (int)(this.pointer & 0xFFFL));
        System.arraycopy(buf, (int)(this.pointer & 0xFFFL), bytes, off, k);
        this.pointer += (long)k;
        return k;
    }

    private long readUntil(long pos) throws IOException {
        int startSlot;
        if (pos < (long)this.length) {
            return pos;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int slot = (int)(pos >> 12);
        for (int k = startSlot = this.length >> 12; k <= slot; ++k) {
            byte[] buf = new byte[4096];
            this.cache.add(buf);
            int len = 4096;
            int off = 0;
            while (len > 0) {
                int nbytes = this.src.read(buf, off, len);
                if (nbytes == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                off += nbytes;
                len -= nbytes;
                this.length += nbytes;
            }
        }
        return this.length;
    }

    @Override
    public void seek(long loc) throws IOException {
        this.ensureOpen();
        if (loc < 0L) {
            throw new IOException("Negative seek position.");
        }
        this.pointer = loc;
    }
}

