/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MemoryCacheRandomAccessOutputStream
extends RandomAccessOutputStream {
    private static final int BUFFER_SHIFT = 12;
    private static final int BUFFER_SIZE = 4096;
    private static final int BUFFER_MASK = 4095;
    private long pointer = 0L;
    private long length = 0L;
    private List<byte[]> cache = new ArrayList<byte[]>(10);
    private long cacheStart = 0L;
    private long flushPos = 0L;

    public MemoryCacheRandomAccessOutputStream(OutputStream dist) {
        super(dist);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.cache.clear();
        this.dist.close();
        this.dist = null;
        this.closed = true;
    }

    @Override
    public void shallowClose() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.cache.clear();
        this.dist = null;
        this.closed = true;
    }

    @Override
    public void disposeBefore(long pos) throws IOException {
        this.ensureOpen();
        long index = pos >> 12;
        if (index < this.cacheStart) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        long numBlocks = Math.min(index - this.cacheStart, (long)this.cache.size());
        for (long i = 0L; i < numBlocks; ++i) {
            this.cache.remove(0);
        }
        this.cacheStart = index;
    }

    private void expandCache(long pos) throws IOException {
        long currIndex = this.cacheStart + (long)this.cache.size() - 1L;
        long toIndex = pos >> 12;
        long numNewBuffers = toIndex - currIndex;
        for (long i = 0L; i < numNewBuffers; ++i) {
            try {
                this.cache.add(new byte[4096]);
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new IOException("No memory left for cache!");
            }
        }
    }

    private byte[] getCacheBlock(long blockNum) throws IOException {
        long blockOffset = blockNum - this.cacheStart;
        if (blockOffset > Integer.MAX_VALUE) {
            throw new IOException("Cache addressing limit exceeded!");
        }
        return this.cache.get((int)blockOffset);
    }

    @Override
    public long getFlushPos() {
        return this.flushPos;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getStreamPointer() {
        return this.pointer;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    @Override
    public void seek(long pos) throws IOException {
        this.ensureOpen();
        if (pos < 0L) {
            throw new IOException("Negative seek position.");
        }
        this.pointer = pos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException("b == null!");
        }
        if (off < 0 || len < 0 || this.pointer < 0L || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        long lastPos = this.pointer + (long)len - 1L;
        if (lastPos >= this.length) {
            this.expandCache(lastPos);
            this.length = lastPos + 1L;
        }
        int offset = (int)(this.pointer & 0xFFFL);
        while (len > 0) {
            byte[] buf = this.getCacheBlock(this.pointer >> 12);
            int nbytes = Math.min(len, 4096 - offset);
            System.arraycopy(b, off, buf, offset, nbytes);
            this.pointer += (long)nbytes;
            off += nbytes;
            len -= nbytes;
            offset = 0;
        }
    }

    @Override
    public void write(int value) throws IOException {
        this.ensureOpen();
        if (this.pointer < 0L) {
            throw new ArrayIndexOutOfBoundsException("pointer < 0");
        }
        if (this.pointer >= this.length) {
            this.expandCache(this.pointer);
            this.length = this.pointer + 1L;
        }
        byte[] buf = this.getCacheBlock(this.pointer >> 12);
        int offset = (int)(this.pointer++ & 0xFFFL);
        buf[offset] = (byte)value;
    }

    @Override
    public void writeToStream(long len) throws IOException {
        this.ensureOpen();
        if (len == 0L) {
            return;
        }
        if (this.pointer + len > this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        if (this.pointer < 0L || len < 0L) {
            throw new IndexOutOfBoundsException("Negative pointer or len");
        }
        long bufIndex = this.pointer >> 12;
        if (bufIndex < this.cacheStart) {
            throw new IndexOutOfBoundsException("pointer already disposed");
        }
        int offset = (int)(this.pointer & 0xFFFL);
        byte[] buf = this.getCacheBlock(bufIndex++);
        while (len > 0L) {
            if (buf == null) {
                buf = this.getCacheBlock(bufIndex++);
                offset = 0;
            }
            int nbytes = (int)Math.min(len, (long)(4096 - offset));
            this.dist.write(buf, offset, nbytes);
            buf = null;
            len -= (long)nbytes;
            this.flushPos += (long)nbytes;
        }
    }
}

