/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;

public class PeekHeadInputStream
extends InputStream {
    private InputStream src;
    private byte[] buffer;
    private int position;
    private boolean closed;

    public PeekHeadInputStream(InputStream src, int bytesToPeek) {
        this.src = src;
        this.buffer = new byte[bytesToPeek];
        try {
            IOUtils.readFully(src, this.buffer);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while reading bytes into buffer");
        }
    }

    public void shallowClose() throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer = null;
        this.src = null;
        this.closed = true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer = null;
        this.src.close();
        this.src = null;
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public byte[] peek(int len) throws IOException {
        this.ensureOpen();
        if (len <= this.buffer.length) {
            return ArrayUtils.subArray(this.buffer, 0, len);
        }
        throw new IllegalArgumentException("Peek length larger than buffer");
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.position >= this.buffer.length) {
            return this.src.read();
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.position >= this.buffer.length) {
            return this.src.read(b, off, len);
        }
        if (this.position + len > this.buffer.length) {
            int bytesAvailable = this.buffer.length - this.position;
            System.arraycopy(this.buffer, this.position, b, off, bytesAvailable);
            this.position += bytesAvailable;
            return bytesAvailable + this.src.read(b, off + bytesAvailable, len - bytesAvailable);
        }
        System.arraycopy(this.buffer, this.position, b, off, len);
        this.position += len;
        return len;
    }
}

