/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.ReadStrategy;
import guilibshadow.cafe4j.io.ReadStrategyMM;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class RandomAccessInputStream
extends InputStream
implements DataInput {
    private ReadStrategy strategy = ReadStrategyMM.getInstance();
    protected InputStream src;
    protected boolean closed;

    protected RandomAccessInputStream(InputStream src) {
        this.src = src;
    }

    public abstract void shallowClose() throws IOException;

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public short getEndian() {
        return this.strategy instanceof ReadStrategyMM ? (short)19789 : 18761;
    }

    public abstract long getStreamPointer();

    @Override
    public abstract int read() throws IOException;

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final char readChar() throws IOException {
        return (char)(this.readShort() & 0xFFFF);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    @Override
    public final int readInt() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf);
        return this.strategy.readInt(buf, 0);
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine is not supported by RandomAccessInputStream.");
    }

    @Override
    public final long readLong() throws IOException {
        byte[] buf = new byte[8];
        this.readFully(buf);
        return this.strategy.readLong(buf, 0);
    }

    public final float readS15Fixed16Number() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf);
        return this.strategy.readS15Fixed16Number(buf, 0);
    }

    @Override
    public final short readShort() throws IOException {
        byte[] buf = new byte[2];
        this.readFully(buf);
        return this.strategy.readShort(buf, 0);
    }

    public final float readU16Fixed16Number() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf);
        return this.strategy.readU16Fixed16Number(buf, 0);
    }

    public final float readU8Fixed8Number() throws IOException {
        byte[] buf = new byte[2];
        this.readFully(buf);
        return this.strategy.readU8Fixed8Number(buf, 0);
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public final long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final String readUTF() throws IOException {
        return new DataInputStream(this).readUTF();
    }

    public abstract void seek(long var1) throws IOException;

    public void setReadStrategy(ReadStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        return (int)this.skip(n);
    }
}

