/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.WriteStrategy;
import guilibshadow.cafe4j.io.WriteStrategyMM;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class RandomAccessOutputStream
extends OutputStream
implements DataOutput {
    private WriteStrategy strategy = WriteStrategyMM.getInstance();
    protected OutputStream dist;
    protected boolean closed;

    protected RandomAccessOutputStream(OutputStream dist) {
        this.dist = dist;
    }

    @Override
    public void close() throws IOException {
        long length;
        long flushPos = this.getFlushPos();
        if (flushPos < (length = this.getLength())) {
            this.seek(flushPos);
            this.writeToStream(length - flushPos);
        }
    }

    public abstract void shallowClose() throws IOException;

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public abstract void disposeBefore(long var1) throws IOException;

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public short getEndian() {
        return this.strategy instanceof WriteStrategyMM ? (short)19789 : 18761;
    }

    public abstract long getFlushPos();

    public abstract long getLength();

    public abstract long getStreamPointer();

    public abstract void reset();

    public abstract void seek(long var1) throws IOException;

    public void setWriteStrategy(WriteStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public final void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    @Override
    public final void writeByte(int value) throws IOException {
        this.write(value);
    }

    @Override
    public final void writeBytes(String value) throws IOException {
        new DataOutputStream(this).writeBytes(value);
    }

    @Override
    public final void writeChar(int value) throws IOException {
        this.writeShort(value);
    }

    @Override
    public final void writeChars(String value) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char v = value.charAt(i);
            this.writeShort(v);
        }
    }

    @Override
    public final void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public final void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public final void writeInt(int value) throws IOException {
        byte[] buf = new byte[4];
        this.strategy.writeInt(buf, 0, value);
        this.write(buf, 0, 4);
    }

    @Override
    public final void writeLong(long value) throws IOException {
        byte[] buf = new byte[8];
        this.strategy.writeLong(buf, 0, value);
        this.write(buf, 0, 8);
    }

    public final void writeS15Fixed16Number(float value) throws IOException {
        byte[] buf = new byte[4];
        this.strategy.writeS15Fixed16Number(buf, 0, value);
        this.write(buf, 0, 4);
    }

    @Override
    public final void writeShort(int value) throws IOException {
        byte[] buf = new byte[2];
        this.strategy.writeShort(buf, 0, value);
        this.write(buf, 0, 2);
    }

    public abstract void writeToStream(long var1) throws IOException;

    public final void writeU16Fixed16Number(float value) throws IOException {
        byte[] buf = new byte[4];
        this.strategy.writeU16Fixed16Number(buf, 0, value);
        this.write(buf, 0, 4);
    }

    public final void writeU8Fixed8Number(float value) throws IOException {
        byte[] buf = new byte[2];
        this.strategy.writeU8Fixed8Number(buf, 0, value);
        this.write(buf, 0, 2);
    }

    @Override
    public final void writeUTF(String value) throws IOException {
        new DataOutputStream(this).writeUTF(value);
    }
}

