/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.io.ReadStrategy;
import java.io.IOException;
import java.io.InputStream;

public class ReadStrategyII
implements ReadStrategy {
    private static final ReadStrategyII instance = new ReadStrategyII();

    public static ReadStrategyII getInstance() {
        return instance;
    }

    private ReadStrategyII() {
    }

    @Override
    public int readInt(byte[] buf, int start_idx) {
        return buf[start_idx++] & 0xFF | (buf[start_idx++] & 0xFF) << 8 | (buf[start_idx++] & 0xFF) << 16 | (buf[start_idx++] & 0xFF) << 24;
    }

    @Override
    public int readInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        return (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    @Override
    public long readLong(byte[] buf, int start_idx) {
        return (long)buf[start_idx++] & 0xFFL | (((long)buf[start_idx++] & 0xFFL) << 8 | ((long)buf[start_idx++] & 0xFFL) << 16 | ((long)buf[start_idx++] & 0xFFL) << 24 | ((long)buf[start_idx++] & 0xFFL) << 32 | ((long)buf[start_idx++] & 0xFFL) << 40 | ((long)buf[start_idx++] & 0xFFL) << 48 | ((long)buf[start_idx] & 0xFFL) << 56);
    }

    @Override
    public long readLong(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        IOUtils.readFully(is, buf);
        return ((long)buf[7] & 0xFFL) << 56 | ((long)buf[6] & 0xFFL) << 48 | ((long)buf[5] & 0xFFL) << 40 | ((long)buf[4] & 0xFFL) << 32 | ((long)buf[3] & 0xFFL) << 24 | ((long)buf[2] & 0xFFL) << 16 | ((long)buf[1] & 0xFFL) << 8 | (long)buf[0] & 0xFFL;
    }

    @Override
    public float readS15Fixed16Number(byte[] buf, int start_idx) {
        short s15 = (short)(buf[start_idx++] & 0xFF | (buf[start_idx++] & 0xFF) << 8);
        int fixed16 = buf[start_idx++] & 0xFF | (buf[start_idx] & 0xFF) << 8;
        return (float)s15 + (float)fixed16 / 65536.0f;
    }

    @Override
    public float readS15Fixed16Number(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        short s15 = (short)(buf[0] & 0xFF | (buf[1] & 0xFF) << 8);
        int fixed16 = buf[2] & 0xFF | (buf[3] & 0xFF) << 8;
        return (float)s15 + (float)fixed16 / 65536.0f;
    }

    @Override
    public short readShort(byte[] buf, int start_idx) {
        return (short)(buf[start_idx++] & 0xFF | (buf[start_idx] & 0xFF) << 8);
    }

    @Override
    public short readShort(InputStream is) throws IOException {
        byte[] buf = new byte[2];
        IOUtils.readFully(is, buf);
        return (short)((buf[1] & 0xFF) << 8 | buf[0] & 0xFF);
    }

    @Override
    public float readU16Fixed16Number(byte[] buf, int start_idx) {
        int u16 = buf[start_idx++] & 0xFF | (buf[start_idx++] & 0xFF) << 8;
        int fixed16 = buf[start_idx++] & 0xFF | (buf[start_idx] & 0xFF) << 8;
        return (float)u16 + (float)fixed16 / 65536.0f;
    }

    @Override
    public float readU16Fixed16Number(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        int u16 = buf[0] & 0xFF | (buf[1] & 0xFF) << 8;
        int fixed16 = buf[2] & 0xFF | (buf[3] & 0xFF) << 8;
        return (float)u16 + (float)fixed16 / 65536.0f;
    }

    @Override
    public float readU8Fixed8Number(byte[] buf, int start_idx) {
        int u8 = buf[start_idx++] & 0xFF;
        int fixed8 = buf[start_idx] & 0xFF;
        return (float)u8 + (float)fixed8 / 256.0f;
    }

    @Override
    public float readU8Fixed8Number(InputStream is) throws IOException {
        byte[] buf = new byte[2];
        IOUtils.readFully(is, buf);
        int u8 = buf[0] & 0xFF;
        int fixed8 = buf[1] & 0xFF;
        return (float)u8 + (float)fixed8 / 256.0f;
    }

    @Override
    public long readUnsignedInt(byte[] buf, int start_idx) {
        return (long)(buf[start_idx++] & 0xFF | (buf[start_idx++] & 0xFF) << 8 | (buf[start_idx++] & 0xFF) << 16 | (buf[start_idx++] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        IOUtils.readFully(is, buf);
        return (long)((buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF) & 0xFFFFFFFFL;
    }

    @Override
    public int readUnsignedShort(byte[] buf, int start_idx) {
        return buf[start_idx++] & 0xFF | (buf[start_idx] & 0xFF) << 8;
    }

    @Override
    public int readUnsignedShort(InputStream is) throws IOException {
        byte[] buf = new byte[2];
        IOUtils.readFully(is, buf);
        return (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }
}

