/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.WriteStrategy;
import java.io.IOException;
import java.io.OutputStream;

public class WriteStrategyMM
implements WriteStrategy {
    private static final WriteStrategyMM instance = new WriteStrategyMM();

    public static WriteStrategyMM getInstance() {
        return instance;
    }

    private WriteStrategyMM() {
    }

    @Override
    public void writeInt(byte[] buf, int start_idx, int value) throws IOException {
        byte[] tmp = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        System.arraycopy(tmp, 0, buf, start_idx, 4);
    }

    @Override
    public void writeInt(OutputStream os, int value) throws IOException {
        os.write(new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value});
    }

    @Override
    public void writeLong(byte[] buf, int start_idx, long value) throws IOException {
        byte[] tmp = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        System.arraycopy(tmp, 0, buf, start_idx, 8);
    }

    @Override
    public void writeLong(OutputStream os, long value) throws IOException {
        os.write(new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value});
    }

    @Override
    public void writeS15Fixed16Number(byte[] buf, int start_idx, float value) throws IOException {
        if (value < -32768.0f || value >= 32768.0f || Float.isNaN(value)) {
            throw new IllegalArgumentException(value + " is not a valid S15Fixed16Number");
        }
        if (value == 0.0f) {
            this.writeInt(buf, start_idx, 0);
        } else if (value > 0.0f) {
            this.writeU16Fixed16Number(buf, start_idx, value);
        } else {
            int s15 = (int)Math.floor(value);
            int fixed16 = (int)((value - (float)s15) * 65536.0f);
            buf[start_idx++] = (byte)(s15 >>> 8);
            buf[start_idx++] = (byte)s15;
            buf[start_idx++] = (byte)(fixed16 >>> 8);
            buf[start_idx] = (byte)fixed16;
        }
    }

    @Override
    public void writeS15Fixed16Number(OutputStream os, float value) throws IOException {
        if (value < -32768.0f || value >= 32768.0f || Float.isNaN(value)) {
            throw new IllegalArgumentException(value + " is not a valid S15Fixed16Number");
        }
        if (value == 0.0f) {
            this.writeInt(os, 0);
        } else if (value > 0.0f) {
            this.writeU16Fixed16Number(os, value);
        } else {
            int s15 = (int)Math.floor(value);
            int fixed16 = (int)((value - (float)s15) * 65536.0f);
            os.write(new byte[]{(byte)(s15 >>> 8), (byte)s15, (byte)(fixed16 >>> 8), (byte)fixed16});
        }
    }

    @Override
    public void writeShort(byte[] buf, int start_idx, int value) throws IOException {
        buf[start_idx] = (byte)(value >>> 8);
        buf[start_idx + 1] = (byte)value;
    }

    @Override
    public void writeShort(OutputStream os, int value) throws IOException {
        os.write(new byte[]{(byte)(value >>> 8), (byte)value});
    }

    @Override
    public void writeU16Fixed16Number(byte[] buf, int start_idx, float value) throws IOException {
        if (value < 0.0f || value >= 65536.0f || Float.isNaN(value)) {
            throw new IllegalArgumentException(value + " is not a valid U16Fixed16Number");
        }
        if (value == 0.0f) {
            this.writeInt(buf, start_idx, 0);
        } else {
            int s15 = (int)value;
            int fixed16 = (int)((value - (float)s15) * 65536.0f);
            buf[start_idx++] = (byte)(s15 >>> 8);
            buf[start_idx++] = (byte)s15;
            buf[start_idx++] = (byte)(fixed16 >>> 8);
            buf[start_idx] = (byte)fixed16;
        }
    }

    @Override
    public void writeU16Fixed16Number(OutputStream os, float value) throws IOException {
        if (value < 0.0f || value >= 65536.0f || Float.isNaN(value)) {
            throw new IllegalArgumentException(value + " is not a valid U16Fixed16Number");
        }
        if (value == 0.0f) {
            this.writeInt(os, 0);
        } else {
            int s15 = (int)value;
            int fixed16 = (int)((value - (float)s15) * 65536.0f);
            os.write(new byte[]{(byte)(s15 >>> 8), (byte)s15, (byte)(fixed16 >>> 8), (byte)fixed16});
        }
    }

    @Override
    public void writeU8Fixed8Number(byte[] buf, int start_idx, float value) throws IOException {
        if (value < 0.0f || value >= 255.9961f || Float.isNaN(value)) {
            throw new IllegalArgumentException(value + " is not a valid U8ixed8Number");
        }
        if (value == 0.0f) {
            this.writeShort(buf, start_idx, 0);
        } else {
            int u8 = (int)value;
            int fixed8 = (int)((value - (float)u8) * 256.0f);
            buf[start_idx++] = (byte)u8;
            buf[start_idx] = (byte)fixed8;
        }
    }

    @Override
    public void writeU8Fixed8Number(OutputStream os, float value) throws IOException {
        if (value < 0.0f || value >= 255.9961f || Float.isNaN(value)) {
            throw new IllegalArgumentException(value + " is not a valid U8Fixed8Number");
        }
        if (value == 0.0f) {
            this.writeShort(os, 0);
        } else {
            int u8 = (int)value;
            int fixed8 = (int)((value - (float)u8) * 256.0f);
            os.write(new byte[]{(byte)u8, (byte)fixed8});
        }
    }
}

