/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.string;

import guilibshadow.cafe4j.util.ArrayUtils;

public final class Base64 {
    private static final char[] base64Map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private static byte[] toUTF8ByteArray(String s) {
        byte[] buffer = new byte[3 * s.length()];
        int index = 0;
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ichar = s.charAt(i);
            if (ichar >= '\u0080' && ichar <= '\u07ff') {
                buffer[index++] = (byte)(0xC0 | ichar >> 6 & 0x1F);
                buffer[index++] = (byte)(0x80 | ichar & 0x3F);
                count += 2;
                continue;
            }
            if (ichar >= '\u0800' && ichar <= '\uffff') {
                buffer[index++] = (byte)(0xE0 | ichar >> 12 & 0xF);
                buffer[index++] = (byte)(0x80 | ichar >> 6 & 0x3F);
                buffer[index++] = (byte)(0x80 | ichar & 0x3F);
                count += 3;
                continue;
            }
            if (ichar >= '\u0000' && ichar <= '\u007f') {
                buffer[index++] = (byte)(0 | ichar & 0x7F);
                ++count;
                continue;
            }
            throw new RuntimeException("Unsupported encoding character length!\n");
        }
        return ArrayUtils.subArray(buffer, 0, count);
    }

    public static String encode(String s) {
        return Base64.encode(Base64.toUTF8ByteArray(s));
    }

    public static String encode(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        String padding = "";
        if (buf.length == 0) {
            return "";
        }
        switch (buf.length % 3) {
            case 1: {
                padding = padding + base64Map[buf[buf.length - 1] >>> 2 & 0x3F];
                padding = padding + base64Map[buf[buf.length - 1] << 4 & 0x3F];
                padding = padding + "==";
                break;
            }
            case 2: {
                padding = padding + base64Map[buf[buf.length - 2] >>> 2 & 0x3F];
                padding = padding + base64Map[buf[buf.length - 2] << 4 & 0x3F | buf[buf.length - 1] >>> 4 & 0x3F];
                padding = padding + base64Map[buf[buf.length - 1] << 2 & 0x3F];
                padding = padding + "=";
                break;
            }
        }
        int temp = 0;
        int index = 0;
        int i = 0;
        while (i < buf.length - buf.length % 3) {
            temp = buf[i++] << 16 & 0xFF0000 | buf[i++] << 8 & 0xFF00 | buf[i++] & 0xFF;
            index = temp >> 18 & 0x3F;
            sb.append(base64Map[index]);
            if (sb.length() % 76 == 0) {
                sb.append('\n');
            }
            index = temp >> 12 & 0x3F;
            sb.append(base64Map[index]);
            if (sb.length() % 76 == 0) {
                sb.append('\n');
            }
            index = temp >> 6 & 0x3F;
            sb.append(base64Map[index]);
            if (sb.length() % 76 == 0) {
                sb.append('\n');
            }
            index = temp & 0x3F;
            sb.append(base64Map[index]);
            if (sb.length() % 76 != 0) continue;
            sb.append('\n');
        }
        sb.append(padding);
        return sb.toString();
    }

    public static String decode(String s) throws Exception {
        return new String(Base64.decodeToByteArray(s), "UTF-8");
    }

    public static byte[] decodeToByteArray(String s) throws Exception {
        if (s.length() == 0) {
            return null;
        }
        byte[] buf = s.getBytes("iso-8859-1");
        byte[] debuf = new byte[buf.length * 3 / 4];
        byte[] tempBuf = new byte[4];
        int index = 0;
        int index1 = 0;
        int count = 0;
        int count1 = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] >= 65 && buf[i] < 91) {
                tempBuf[index++] = (byte)(buf[i] - 65);
            } else if (buf[i] >= 97 && buf[i] < 123) {
                tempBuf[index++] = (byte)(buf[i] - 71);
            } else if (buf[i] >= 48 && buf[i] < 58) {
                tempBuf[index++] = (byte)(buf[i] + 4);
            } else if (buf[i] == 43) {
                tempBuf[index++] = 62;
            } else if (buf[i] == 47) {
                tempBuf[index++] = 63;
            } else if (buf[i] == 61) {
                tempBuf[index++] = 0;
                ++count1;
            } else {
                if (buf[i] == 10 || buf[i] == 13 || buf[i] == 32 || buf[i] != 9) continue;
                continue;
            }
            if (index != 4) continue;
            int temp = tempBuf[0] << 18 | tempBuf[1] << 12 | tempBuf[2] << 6 | tempBuf[3];
            debuf[index1++] = (byte)(temp >> 16);
            debuf[index1++] = (byte)(temp >> 8 & 0xFF);
            debuf[index1++] = (byte)(temp & 0xFF);
            count += 3;
            index = 0;
        }
        return ArrayUtils.subArray(debuf, 0, count - count1);
    }
}

