/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.string;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char[] HEXES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String byteArrayToHexString(byte[] bytes) {
        return StringUtils.byteArrayToHexString(bytes, 0, bytes.length);
    }

    public static String byteArrayToHexString(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "[]";
        }
        if (offset < 0 || offset >= bytes.length) {
            throw new IllegalArgumentException("Offset out of array bound!");
        }
        int endOffset = offset + Math.min(length, bytes.length);
        if (endOffset > bytes.length) {
            length = bytes.length - offset;
        }
        StringBuilder hex = new StringBuilder(5 * length + 2);
        hex.append("[");
        for (int i = offset; i < endOffset; ++i) {
            hex.append("0x").append(HEXES[(bytes[i] & 0xF0) >> 4]).append(HEXES[bytes[i] & 0xF]).append(",");
        }
        if (hex.length() > 1) {
            hex.deleteCharAt(hex.length() - 1);
        }
        if (endOffset < bytes.length) {
            hex.append(" ...");
        }
        hex.append("]");
        return hex.toString();
    }

    public static String byteToHexString(byte b) {
        return String.format("0x%02X ", b);
    }

    public static String capitalize(String s) {
        StringBuffer myStringBuffer = new StringBuffer();
        Pattern p = Pattern.compile("\\b(\\w)(\\w*)");
        Matcher m = p.matcher(s);
        while (m.find()) {
            if (Character.isUpperCase(m.group().charAt(0))) continue;
            m.appendReplacement(myStringBuffer, m.group(1).toUpperCase() + "$2");
        }
        return m.appendTail(myStringBuffer).toString();
    }

    public static String capitalizeFully(String s) {
        return StringUtils.capitalize(s.toLowerCase());
    }

    public static String concat(Iterable<? extends CharSequence> strings, String delimiter) {
        int capacity = 0;
        int delimLength = delimiter.length();
        for (CharSequence charSequence : strings) {
            if (StringUtils.isNullOrEmpty(charSequence)) continue;
            capacity += charSequence.length() + delimLength;
        }
        StringBuilder stringBuilder = new StringBuilder(capacity);
        for (CharSequence charSequence : strings) {
            if (StringUtils.isNullOrEmpty(charSequence)) continue;
            stringBuilder.append(charSequence);
            stringBuilder.append(delimiter);
        }
        int n = stringBuilder.lastIndexOf(delimiter);
        stringBuilder.delete(n, stringBuilder.length());
        return stringBuilder.toString();
    }

    public static String concat(String first, String second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        StringBuilder sb = new StringBuilder(first.length() + second.length());
        sb.append(first);
        sb.append(second);
        return sb.toString();
    }

    public static String concat(String first, String ... strings) {
        StringBuilder sb = first != null ? new StringBuilder(first) : new StringBuilder();
        for (String s : strings) {
            if (StringUtils.isNullOrEmpty(s)) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    public static <T extends CharSequence> String concat(T[] strings, String delimiter) {
        int capacity = 0;
        int delimLength = delimiter.length();
        for (T value : strings) {
            if (StringUtils.isNullOrEmpty(value)) continue;
            capacity += value.length() + delimLength;
        }
        StringBuilder buffer = new StringBuilder(capacity);
        for (T value : strings) {
            if (StringUtils.isNullOrEmpty(value)) continue;
            buffer.append((CharSequence)value);
            buffer.append(delimiter);
        }
        int lastIndexOfDelimiter = buffer.lastIndexOf(delimiter);
        buffer.delete(lastIndexOfDelimiter, buffer.length());
        return buffer.toString();
    }

    public static boolean contains(String input, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.find();
    }

    public static String decimalToDMS(double coord) {
        double mod = coord % 1.0;
        int degrees = (int)coord;
        coord = mod * 60.0;
        mod = coord % 1.0;
        int minutes = (int)coord;
        coord = mod * 60.0;
        int seconds = (int)coord;
        String output = degrees + 176 + minutes + "'" + seconds + "\"";
        return output;
    }

    public double DMSToDecimal(String hemisphereOUmeridien, double degrees, double minutes, double seconds) {
        double LatOrLon = 0.0;
        double sign = 1.0;
        if (hemisphereOUmeridien == "W" || hemisphereOUmeridien == "S") {
            sign = -1.0;
        }
        LatOrLon = sign * (Math.floor(degrees) + Math.floor(minutes) / 60.0 + seconds / 3600.0);
        return LatOrLon;
    }

    public static String encodeURL(String url) {
        String result = null;
        try {
            result = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String escapeHTML(String input) {
        Iterator<Character> itr = StringUtils.stringIterator(input);
        StringBuilder result = new StringBuilder();
        block35: while (itr.hasNext()) {
            Character c = itr.next();
            switch (c.charValue()) {
                case '<': {
                    result.append("&lt;");
                    continue block35;
                }
                case '>': {
                    result.append("&gt;");
                    continue block35;
                }
                case '&': {
                    result.append("&amp;");
                    continue block35;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block35;
                }
                case '\t': {
                    result.append("&#009;");
                    continue block35;
                }
                case '!': {
                    result.append("&#033;");
                    continue block35;
                }
                case '#': {
                    result.append("&#035;");
                    continue block35;
                }
                case '$': {
                    result.append("&#036;");
                    continue block35;
                }
                case '%': {
                    result.append("&#037;");
                    continue block35;
                }
                case '\'': {
                    result.append("&#039;");
                    continue block35;
                }
                case '(': {
                    result.append("&#040;");
                    continue block35;
                }
                case ')': {
                    result.append("&#041;");
                    continue block35;
                }
                case '*': {
                    result.append("&#042;");
                    continue block35;
                }
                case '+': {
                    result.append("&#043;");
                    continue block35;
                }
                case ',': {
                    result.append("&#044;");
                    continue block35;
                }
                case '-': {
                    result.append("&#045;");
                    continue block35;
                }
                case '.': {
                    result.append("&#046;");
                    continue block35;
                }
                case '/': {
                    result.append("&#047;");
                    continue block35;
                }
                case ':': {
                    result.append("&#058;");
                    continue block35;
                }
                case ';': {
                    result.append("&#059;");
                    continue block35;
                }
                case '=': {
                    result.append("&#061;");
                    continue block35;
                }
                case '?': {
                    result.append("&#063;");
                    continue block35;
                }
                case '@': {
                    result.append("&#064;");
                    continue block35;
                }
                case '[': {
                    result.append("&#091;");
                    continue block35;
                }
                case '\\': {
                    result.append("&#092;");
                    continue block35;
                }
                case ']': {
                    result.append("&#093;");
                    continue block35;
                }
                case '^': {
                    result.append("&#094;");
                    continue block35;
                }
                case '_': {
                    result.append("&#095;");
                    continue block35;
                }
                case '`': {
                    result.append("&#096;");
                    continue block35;
                }
                case '{': {
                    result.append("&#123;");
                    continue block35;
                }
                case '|': {
                    result.append("&#124;");
                    continue block35;
                }
                case '}': {
                    result.append("&#125;");
                    continue block35;
                }
                case '~': {
                    result.append("&#126;");
                    continue block35;
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String escapeQueryStringAmp(String queryString) {
        return queryString.replace("&", "&amp;");
    }

    public static String escapeRegex(String input) {
        Iterator<Character> itr = StringUtils.stringIterator(input);
        StringBuilder result = new StringBuilder();
        block4: while (itr.hasNext()) {
            Character c = itr.next();
            switch (c.charValue()) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '^': 
                case '{': {
                    result.append("\\").append(c);
                    continue block4;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block4;
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String generateMD5(byte[] message) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No such algorithm: MD5");
        }
        return StringUtils.toHexString(md.digest(message));
    }

    public static String intToHexString(int value) {
        StringBuilder buffer = new StringBuilder(10);
        buffer.append("0x");
        buffer.append(HEXES[value & 0xF]);
        buffer.append(HEXES[(value & 0xF0) >>> 4]);
        buffer.append(HEXES[(value & 0xF00) >>> 8]);
        buffer.append(HEXES[(value & 0xF000) >>> 12]);
        buffer.append(HEXES[(value & 0xF0000) >>> 16]);
        buffer.append(HEXES[(value & 0xF00000) >>> 20]);
        buffer.append(HEXES[(value & 0xF000000) >>> 24]);
        buffer.append(HEXES[(value & 0xF0000000) >>> 28]);
        return buffer.toString();
    }

    public static String intToHexStringMM(int value) {
        StringBuilder buffer = new StringBuilder(10);
        buffer.append("0x");
        buffer.append(HEXES[(value & 0xF0000000) >>> 28]);
        buffer.append(HEXES[(value & 0xF000000) >>> 24]);
        buffer.append(HEXES[(value & 0xF00000) >>> 20]);
        buffer.append(HEXES[(value & 0xF0000) >>> 16]);
        buffer.append(HEXES[(value & 0xF000) >>> 12]);
        buffer.append(HEXES[(value & 0xF00) >>> 8]);
        buffer.append(HEXES[(value & 0xF0) >>> 4]);
        buffer.append(HEXES[value & 0xF]);
        return buffer.toString();
    }

    public static boolean isInCharset(String input, String encoding) {
        Charset charset = null;
        try {
            charset = Charset.forName(encoding);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        String output = new String(input.getBytes(charset), charset);
        return output.equals(input);
    }

    public static boolean isNullOrEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String longArrayToString(int[] data, boolean unsigned) {
        return StringUtils.longArrayToString(data, 0, data.length, unsigned);
    }

    public static String longArrayToString(int[] data, int offset, int length, boolean unsigned) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "[]";
        }
        if (offset < 0 || offset >= data.length) {
            throw new IllegalArgumentException("Offset out of array bound!");
        }
        int endOffset = offset + Math.min(length, data.length);
        if (endOffset > data.length) {
            length = data.length - offset;
        }
        StringBuilder longs = new StringBuilder();
        longs.append("[");
        for (int i = offset; i < endOffset; ++i) {
            if (unsigned) {
                longs.append((long)data[i] & 0xFFFFFFFFL);
            } else {
                longs.append(data[i]);
            }
            longs.append(",");
        }
        if (longs.length() > 1) {
            longs.deleteCharAt(longs.length() - 1);
        }
        if (endOffset < data.length) {
            longs.append(" ...");
        }
        longs.append("]");
        return longs.toString();
    }

    public static boolean parseBoolean(String s) {
        return Boolean.parseBoolean(s);
    }

    public static byte parseByte(String s) {
        return Byte.parseByte(s);
    }

    public static byte parseByte(String s, int radix) {
        return Byte.parseByte(s, radix);
    }

    public static double parseDouble(String s) {
        return Double.parseDouble(s);
    }

    public static float parseFloat(String s) {
        return Float.parseFloat(s);
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s);
    }

    public static int parseInt(String s, int radix) {
        return Integer.parseInt(s, radix);
    }

    public static long parseLong(String s) {
        return Long.parseLong(s);
    }

    public static long parseLong(String s, int radix) {
        return Long.parseLong(s, radix);
    }

    public static short parseShort(String s) {
        return Short.parseShort(s);
    }

    public static short parseShort(String s, int radix) {
        return Short.parseShort(s, radix);
    }

    public static String quoteRegexReplacement(String replacement) {
        return Matcher.quoteReplacement(replacement);
    }

    public static String rationalArrayToString(int[] data, boolean unsigned) {
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("Data length is odd number, expect even!");
        }
        StringBuilder rational = new StringBuilder();
        rational.append("[");
        for (int i = 0; i < data.length; i += 2) {
            long numerator = data[i];
            long denominator = data[i + 1];
            if (unsigned) {
                numerator = (long)data[i] & 0xFFFFFFFFL;
                denominator = (long)data[i + 1] & 0xFFFFFFFFL;
            }
            rational.append(numerator);
            rational.append("/");
            rational.append(denominator);
            rational.append(",");
        }
        rational.deleteCharAt(rational.length() - 1);
        rational.append("]");
        return rational.toString();
    }

    public static String rationalToString(DecimalFormat df, boolean unsigned, int ... rational) {
        if (rational.length < 2) {
            throw new IllegalArgumentException("Input data length is too short");
        }
        if (rational[1] == 0) {
            throw new ArithmeticException("Divided by zero");
        }
        long numerator = rational[0];
        long denominator = rational[1];
        if (unsigned) {
            numerator &= 0xFFFFFFFFL;
            denominator &= 0xFFFFFFFFL;
        }
        return df.format(1.0 * (double)numerator / (double)denominator);
    }

    public static String replaceLast(String input, String regex, String replacement) {
        return input.replaceAll(regex + "(?!.*" + regex + ")", replacement);
    }

    public static String reverse(String s) {
        if (s == null) {
            return null;
        }
        return new StringBuilder(s).reverse().toString();
    }

    public static String reverse2(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder dest = new StringBuilder(len);
        for (int i = len - 1; i >= 0; --i) {
            dest.append(s.charAt(i));
        }
        return dest.toString();
    }

    public static String reverse(String str, String delimiter) {
        if (StringUtils.isNullOrEmpty(delimiter)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        StringUtils.reverseIt(str, delimiter, sb);
        return sb.toString();
    }

    public static String reverse2(String str, String delimiter) {
        if (StringUtils.isNullOrEmpty(delimiter) || StringUtils.isNullOrEmpty(str) || str.trim().length() == 0 || str.indexOf(delimiter) < 0) {
            return str;
        }
        String escaptedDelimiter = StringUtils.escapeRegex(delimiter);
        String[] stringArray = str.split(escaptedDelimiter, -1);
        StringBuilder sb = new StringBuilder(str.length() + delimiter.length());
        for (int i = stringArray.length - 1; i >= 0; --i) {
            sb.append(stringArray[i]).append(delimiter);
        }
        return sb.substring(0, sb.lastIndexOf(delimiter));
    }

    private static void reverseIt(String str, String delimiter, StringBuilder sb) {
        if (StringUtils.isNullOrEmpty(str) || str.trim().length() == 0 || str.indexOf(delimiter) < 0) {
            sb.append(str);
            return;
        }
        StringUtils.reverseIt(str.substring(str.indexOf(delimiter) + delimiter.length()), delimiter, sb);
        sb.append(delimiter);
        sb.append(str.substring(0, str.indexOf(delimiter)));
    }

    public static String reverseWords(String s) {
        String[] stringArray = s.split("\\b");
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = stringArray.length - 1; i >= 0; --i) {
            sb.append(stringArray[i]);
        }
        return sb.toString();
    }

    public static String shortArrayToString(short[] data, boolean unsigned) {
        return StringUtils.shortArrayToString(data, 0, data.length, unsigned);
    }

    public static String shortArrayToString(short[] data, int offset, int length, boolean unsigned) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "[]";
        }
        if (offset < 0 || offset >= data.length) {
            throw new IllegalArgumentException("Offset out of array bound!");
        }
        int endOffset = offset + Math.min(length, data.length);
        if (endOffset > data.length) {
            length = data.length - offset;
        }
        StringBuilder shorts = new StringBuilder();
        shorts.append("[");
        for (int i = offset; i < endOffset; ++i) {
            if (unsigned) {
                shorts.append(data[i] & 0xFFFF);
            } else {
                shorts.append(data[i]);
            }
            shorts.append(",");
        }
        if (shorts.length() > 1) {
            shorts.deleteCharAt(shorts.length() - 1);
        }
        if (endOffset < data.length) {
            shorts.append(" ...");
        }
        shorts.append("]");
        return shorts.toString();
    }

    public static String shortToHexString(short value) {
        StringBuilder buffer = new StringBuilder(6);
        buffer.append("0x");
        buffer.append(HEXES[value & 0xF]);
        buffer.append(HEXES[(value & 0xF0) >>> 4]);
        buffer.append(HEXES[(value & 0xF00) >>> 8]);
        buffer.append(HEXES[(value & 0xF000) >>> 12]);
        return buffer.toString();
    }

    public static String shortToHexStringMM(short value) {
        StringBuilder buffer = new StringBuilder(6);
        buffer.append("0x");
        buffer.append(HEXES[(value & 0xF000) >>> 12]);
        buffer.append(HEXES[(value & 0xF00) >>> 8]);
        buffer.append(HEXES[(value & 0xF0) >>> 4]);
        buffer.append(HEXES[value & 0xF]);
        return buffer.toString();
    }

    public static String stackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Iterator<Character> stringIterator(final String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Iterator<Character>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < string.length();
            }

            @Override
            public Character next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.valueOf(string.charAt(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String text2HTML(String s) {
        StringBuilder builder = new StringBuilder();
        boolean previousWasASpace = false;
        block8: for (char c : s.toCharArray()) {
            if (c == ' ') {
                if (previousWasASpace) {
                    builder.append("&nbsp;");
                    previousWasASpace = false;
                    continue;
                }
                previousWasASpace = true;
            } else {
                previousWasASpace = false;
            }
            switch (c) {
                case '<': {
                    builder.append("&lt;");
                    continue block8;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block8;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    builder.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    builder.append("<br>");
                    continue block8;
                }
                case '\t': {
                    builder.append("&nbsp; &nbsp; &nbsp;");
                    continue block8;
                }
                default: {
                    if (c < '\u0080') {
                        builder.append(c);
                        continue block8;
                    }
                    builder.append("&#").append((int)c).append(";");
                }
            }
        }
        return builder.toString();
    }

    public static String toHexString(byte[] bytes) {
        return StringUtils.toHexString(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        if (offset < 0 || offset >= bytes.length) {
            throw new IllegalArgumentException("Offset out of array bound!");
        }
        int endOffset = offset + Math.min(length, bytes.length);
        if (endOffset > bytes.length) {
            length = bytes.length - offset;
        }
        StringBuilder hex = new StringBuilder(5 * length + 2);
        for (int i = offset; i < endOffset; ++i) {
            hex.append(HEXES[(bytes[i] & 0xF0) >> 4]).append(HEXES[bytes[i] & 0xF]);
        }
        return hex.toString();
    }

    public static String toUTF16BE(byte[] data, int start, int length) {
        String retVal = "";
        try {
            retVal = new String(data, start, length, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private StringUtils() {
    }
}

