/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.string;

import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtils.class);

    public static void addChild(Node parent, Node child) {
        parent.appendChild(child);
    }

    public static void addText(Document doc, Node parent, String data) {
        parent.appendChild(doc.createTextNode(data));
    }

    public static Document createDocumentNode() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return builder.newDocument();
    }

    public static Element createElement(Document doc, String tagName) {
        return doc.createElement(tagName);
    }

    public static Document createXML(byte[] xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document document = null;
        try {
            document = builder.parse(new ByteArrayInputStream(xml));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    public static Document createXML(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document document = null;
        InputSource source = new InputSource(new StringReader(xml));
        try {
            document = builder.parse(source);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    public static String escapeXML(String input) {
        Iterator<Character> itr = StringUtils.stringIterator(input);
        StringBuilder result = new StringBuilder();
        block7: while (itr.hasNext()) {
            Character c = itr.next();
            switch (c.charValue()) {
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block7;
                }
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String getAttribute(Document doc, String tagName, String attribute) {
        if (doc == null || tagName == null || attribute == null) {
            return "";
        }
        NodeList nodes = doc.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String attr = ((Element)nodes.item(i)).getAttribute(attribute);
            if (StringUtils.isNullOrEmpty(attr)) continue;
            return attr;
        }
        return "";
    }

    public static void insertLeadingPI(Document doc, String target, String data) {
        Element element = doc.getDocumentElement();
        ProcessingInstruction pi = doc.createProcessingInstruction(target, data);
        doc.insertBefore(pi, element);
    }

    public static void insertTrailingPI(Document doc, String target, String data) {
        ProcessingInstruction pi = doc.createProcessingInstruction(target, data);
        doc.appendChild(pi);
    }

    public static void printNode(Node node, String increment) {
        StringBuilder xmlTree = new StringBuilder();
        String indent = "";
        XMLUtils.print(node, indent, increment, xmlTree);
        LOGGER.info("\n{}", (Object)xmlTree);
    }

    private static void print(Node node, String indent, String increment, StringBuilder stringBuilder) {
        if (node != null) {
            if (indent == null) {
                indent = "";
            }
            switch (node.getNodeType()) {
                case 9: {
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        XMLUtils.print(child, indent, increment, stringBuilder);
                    }
                    break;
                }
                case 10: {
                    DocumentType doctype = (DocumentType)node;
                    stringBuilder.append("<!DOCTYPE " + doctype.getName() + ">\n");
                    break;
                }
                case 1: {
                    Element ele = (Element)node;
                    stringBuilder.append(indent + "<" + ele.getTagName());
                    NamedNodeMap attrs = ele.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node a = attrs.item(i);
                        stringBuilder.append(" " + a.getNodeName() + "='" + XMLUtils.escapeXML(a.getNodeValue()) + "'");
                    }
                    stringBuilder.append(">\n");
                    for (Node child = ele.getFirstChild(); child != null; child = child.getNextSibling()) {
                        XMLUtils.print(child, indent + increment, increment, stringBuilder);
                    }
                    stringBuilder.append(indent + "</" + ele.getTagName() + ">\n");
                    break;
                }
                case 3: {
                    Text textNode = (Text)node;
                    String text = textNode.getData().trim();
                    if (text == null || text.length() <= 0) break;
                    stringBuilder.append(indent + XMLUtils.escapeXML(text) + "\n");
                    break;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    stringBuilder.append(indent + "<?" + pi.getTarget() + " " + pi.getData() + "?>\n");
                    break;
                }
                case 5: {
                    stringBuilder.append(indent + "&" + node.getNodeName() + ";\n");
                    break;
                }
                case 4: {
                    CDATASection cdata = (CDATASection)node;
                    stringBuilder.append(indent + "<![CDATA[" + cdata.getData() + "]]>\n");
                    break;
                }
                case 8: {
                    Comment c = (Comment)node;
                    stringBuilder.append(indent + "<!--" + c.getData() + "-->\n");
                    break;
                }
                default: {
                    LOGGER.error("Unknown node: " + node.getClass().getName());
                }
            }
        }
    }

    public static String removeAttribute(Document doc, String tagName, String attribute) {
        NodeList nodes = doc.getElementsByTagName(tagName);
        String retVal = "";
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element ele = (Element)nodes.item(i);
            String attr = ele.getAttribute(attribute);
            if (StringUtils.isNullOrEmpty(attr)) continue;
            retVal = attr;
            ele.removeAttribute(attribute);
            break;
        }
        return retVal;
    }

    public static byte[] serializeToByteArray(Document doc) throws IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Unable to serialize XML document");
        }
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        String encoding = doc.getInputEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        transformer.setOutputProperty("encoding", encoding);
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Unable to serialize XML document");
        }
        return out.toByteArray();
    }

    public static String serializeToStringLS(Document doc) throws IOException {
        return XMLUtils.serializeToStringLS(doc, doc);
    }

    public static String serializeToStringLS(Document doc, Node node) throws IOException {
        String encoding = doc.getInputEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return XMLUtils.serializeToStringLS(doc, node, encoding);
    }

    public static String serializeToStringLS(Document doc, Node node, String encoding) throws IOException {
        DOMImplementationLS domImpl = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer lsSerializer = domImpl.createLSSerializer();
        LSOutput output = domImpl.createLSOutput();
        output.setEncoding(encoding);
        StringWriter writer = new StringWriter();
        output.setCharacterStream(writer);
        lsSerializer.write(node, output);
        writer.flush();
        return writer.toString();
    }

    public static String serializeToString(Document doc) throws IOException {
        String encoding = doc.getInputEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return XMLUtils.serializeToString(doc, encoding);
    }

    public static String serializeToString(Node node, String encoding) throws IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Unable to serialize XML document");
        }
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", encoding);
        DOMSource source = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Unable to serialize XML document");
        }
        writer.flush();
        return writer.toString();
    }

    public static void showXML(Document document) {
        XMLUtils.printNode(document, "     ");
    }
}

