/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ArrayUtils {
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final byte[] BIT_REVERSE_TABLE = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};

    public static List<Integer> asList(final int[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int i) {
                return a[i];
            }

            @Override
            public Integer set(int i, Integer val) {
                int oldVal = a[i];
                a[i] = val;
                return oldVal;
            }

            @Override
            public int size() {
                return a.length;
            }
        };
    }

    public static void bubbleSort(int[] array) {
        int n = array.length;
        boolean doMore = true;
        while (doMore) {
            --n;
            doMore = false;
            for (int i = 0; i < n; ++i) {
                if (array[i] <= array[i + 1]) continue;
                int temp = array[i];
                array[i] = array[i + 1];
                array[i + 1] = temp;
                doMore = true;
            }
        }
    }

    public static <T extends Comparable<? super T>> void bubbleSort(T[] array) {
        int n = array.length;
        boolean doMore = true;
        while (doMore) {
            --n;
            doMore = false;
            for (int i = 0; i < n; ++i) {
                if (array[i].compareTo(array[i + 1]) <= 0) continue;
                T temp = array[i];
                array[i] = array[i + 1];
                array[i + 1] = temp;
                doMore = true;
            }
        }
    }

    public static <T> boolean checkDuplicate(T[] input) {
        HashSet<T> tempSet = new HashSet<T>();
        for (T str : input) {
            if (tempSet.add(str)) continue;
            return true;
        }
        return false;
    }

    public static byte[] concat(byte[] first, byte[] ... rest) {
        if (first == null) {
            throw new IllegalArgumentException("Firt element is null");
        }
        if (rest.length == 0) {
            return first;
        }
        int totalLength = first.length;
        for (byte[] array : rest) {
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength];
        int offset = first.length;
        System.arraycopy(first, 0, result, 0, offset);
        for (byte[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static <T> T[] concat(T[] ... arrays) {
        if (arrays.length == 0) {
            throw new IllegalArgumentException("Varargs length is zero");
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int totalLength = 0;
        Class<?> returnType = arrays.getClass().getComponentType().getComponentType();
        for (T[] array : arrays) {
            totalLength += array.length;
        }
        Object[] result = (Object[])Array.newInstance(returnType, totalLength);
        int offset = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static <T> T[] concat(Class<T> type, T[] ... arrays) {
        if (type == null) {
            throw new IllegalArgumentException("Input type class is null");
        }
        if (arrays.length == 0) {
            Object[] result = (Object[])Array.newInstance(type, 0);
            return result;
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int totalLength = 0;
        for (T[] array : arrays) {
            totalLength += array.length;
        }
        Object[] result = (Object[])Array.newInstance(type, totalLength);
        int offset = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static int findEqualOrLess(int[] a, int key) {
        return ArrayUtils.findEqualOrLess(a, 0, a.length, key);
    }

    public static int findEqualOrLess(int[] a, int fromIndex, int toIndex, int key) {
        int index = Arrays.binarySearch(a, fromIndex, toIndex, key);
        if (index < 0) {
            index = -index - 1 - 1;
        }
        return index;
    }

    public static <T> int findEqualOrLess(T[] a, int fromIndex, int toIndex, T key, Comparator<? super T> c) {
        int index = Arrays.binarySearch(a, fromIndex, toIndex, key, c);
        if (index < 0) {
            index = -index - 1 - 1;
        }
        return index;
    }

    public static <T> int findEqualOrLess(T[] a, T key, Comparator<? super T> c) {
        return ArrayUtils.findEqualOrLess(a, 0, a.length, key, c);
    }

    public static byte[] flipEndian(byte[] input, int offset, int len, int bits, int scanLineStride, boolean bigEndian) {
        long value = 0L;
        int bits_remain = 0;
        long temp_byte = 0L;
        int empty_bits = 8;
        byte[] output = new byte[input.length];
        int strideCounter = 0;
        int end = offset + len;
        int bufIndex = 0;
        int temp = bits;
        boolean bigEndianOut = !bigEndian;
        block0: while (true) {
            value = !bigEndian ? temp_byte >> 8 - bits_remain : temp_byte & (long)MASK[bits_remain];
            while (bits > bits_remain) {
                if (offset >= end) break block0;
                temp_byte = input[offset++] & 0xFF;
                value = bigEndian ? value << 8 | temp_byte : (value |= temp_byte << bits_remain);
                bits_remain += 8;
            }
            bits_remain -= bits;
            if (bigEndian) {
                value >>= bits_remain;
            }
            if (bigEndianOut) {
                int n = bufIndex;
                output[n] = (byte)((long)output[n] | value >> temp & (long)MASK[empty_bits]);
                for (temp = bits - empty_bits; temp > 8; temp -= 8) {
                    int n2 = ++bufIndex;
                    output[n2] = (byte)((long)output[n2] | value >> temp - 8 & (long)MASK[8]);
                }
                if (temp > 0) {
                    int n3 = ++bufIndex;
                    output[n3] = (byte)((long)output[n3] | (value & (long)MASK[temp]) << 8 - temp);
                    temp -= 8;
                }
            } else {
                temp = bits;
                int n = bufIndex;
                output[n] = (byte)((long)output[n] | (value & (long)MASK[empty_bits]) << 8 - empty_bits);
                value >>= empty_bits;
                temp -= empty_bits;
                while (temp > 8) {
                    int n4 = ++bufIndex;
                    output[n4] = (byte)((long)output[n4] | value & 0xFFL);
                    value >>= 8;
                    temp -= 8;
                }
                if (temp > 0) {
                    int n5 = ++bufIndex;
                    output[n5] = (byte)((long)output[n5] | value & (long)MASK[temp]);
                    temp -= 8;
                }
            }
            empty_bits = -temp;
            if (++strideCounter % scanLineStride != 0) continue;
            empty_bits = 0;
            bits_remain = 0;
        }
        return output;
    }

    public static int fromFloat(float fval) {
        int fbits = Float.floatToIntBits(fval);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val < 2139095040) {
                    return sign | 0x7C00;
                }
                return sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13;
            }
            return sign | 0x7BFF;
        }
        if (val >= 0x38800000) {
            return sign | val - 0x38000000 >>> 13;
        }
        if (val < 0x33000000) {
            return sign;
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val;
    }

    public static byte[] getBitReverseTable() {
        return (byte[])BIT_REVERSE_TABLE.clone();
    }

    public static void insertionsort(int[] array) {
        ArrayUtils.insertionsort(array, 0, array.length - 1);
    }

    public static void insertionsort(int[] array, int start, int end) {
        for (int i = start + 1; i < end + 1; ++i) {
            int temp = array[i];
            for (int j = i; j > start && temp <= array[j - 1]; --j) {
                array[j] = array[j - 1];
            }
            array[j] = temp;
        }
    }

    public static <T extends Comparable<? super T>> void insertionsort(T[] array) {
        ArrayUtils.insertionsort(array, (int)0, (int)(array.length - 1));
    }

    public static <T extends Comparable<? super T>> void insertionsort(T[] array, int start, int end) {
        for (int i = start + 1; i < end + 1; ++i) {
            T temp = array[i];
            for (int j = i; j > start && temp.compareTo(array[j - 1]) <= 0; --j) {
                array[j] = array[j - 1];
            }
            array[j] = temp;
        }
    }

    public static void mergesort(int[] array) {
        ArrayUtils.mergesort(array, new int[array.length], 0, array.length - 1);
    }

    public static void mergesort(int[] array, int left, int right) {
        if (left < 0 || right > array.length - 1) {
            throw new IllegalArgumentException("Array index out of bounds");
        }
        ArrayUtils.mergesort(array, new int[array.length], left, right);
    }

    private static void mergesort(int[] array, int[] temp, int left, int right) {
        if (left < right) {
            int middle = left + (right - left) / 2;
            ArrayUtils.mergesort(array, temp, left, middle);
            ArrayUtils.mergesort(array, temp, middle + 1, right);
            ArrayUtils.merge(array, temp, left, middle, right);
        }
    }

    public static <T extends Comparable<? super T>> void mergesort(T[] array) {
        ArrayUtils.mergesort(array, (int)0, (int)(array.length - 1));
    }

    public static <T extends Comparable<? super T>> void mergesort(T[] array, int left, int right) {
        if (left < 0 || right > array.length - 1) {
            throw new IllegalArgumentException("Array index out of bounds");
        }
        Comparable[] temp = (Comparable[])Array.newInstance(array.getClass().getComponentType(), array.length);
        ArrayUtils.mergesort(array, (Comparable[])temp, (int)left, (int)right);
    }

    private static <T extends Comparable<? super T>> void mergesort(T[] array, T[] temp, int left, int right) {
        if (left < right) {
            int middle = left + (right - left) / 2;
            ArrayUtils.mergesort(array, temp, (int)left, (int)middle);
            ArrayUtils.mergesort(array, temp, (int)(middle + 1), (int)right);
            ArrayUtils.merge(array, temp, (int)left, (int)middle, (int)right);
        }
    }

    private static <T extends Comparable<? super T>> void merge(T[] array, T[] temp, int left, int middle, int right) {
        int i;
        for (i = left; i <= right; ++i) {
            temp[i] = array[i];
        }
        i = left;
        int j = middle + 1;
        int k = left;
        while (i <= middle && j <= right) {
            if (temp[i].compareTo(temp[j]) <= 0) {
                array[k] = temp[i];
                ++i;
            } else {
                array[k] = temp[j];
                ++j;
            }
            ++k;
        }
        while (i <= middle) {
            array[k] = temp[i];
            ++k;
            ++i;
        }
    }

    private static void merge(int[] array, int[] temp, int left, int middle, int right) {
        int i;
        for (i = left; i <= right; ++i) {
            temp[i] = array[i];
        }
        i = left;
        int j = middle + 1;
        int k = left;
        while (i <= middle && j <= right) {
            if (temp[i] <= temp[j]) {
                array[k] = temp[i];
                ++i;
            } else {
                array[k] = temp[j];
                ++j;
            }
            ++k;
        }
        while (i <= middle) {
            array[k] = temp[i];
            ++k;
            ++i;
        }
    }

    public static byte[] packByteArray(byte[] input, int start, int bits, int len) {
        if (bits == 8) {
            return ArrayUtils.subArray(input, start, len);
        }
        if (bits > 8 || bits <= 0) {
            throw new IllegalArgumentException("Invalid value of bits: " + bits);
        }
        byte[] packedBytes = new byte[bits * len + 7 >> 3];
        short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
        int index = 0;
        int empty_bits = 8;
        int end = start + len;
        for (int i = start; i < end; ++i) {
            if (empty_bits >= bits) {
                int n = index++;
                packedBytes[n] = (byte)(packedBytes[n] | (input[i] & mask[bits]) << empty_bits - bits);
                if ((empty_bits -= bits) != 0) continue;
                empty_bits = 8;
                continue;
            }
            int n = index++;
            packedBytes[n] = (byte)(packedBytes[n] | input[i] >> bits - empty_bits & mask[empty_bits]);
            int n2 = index;
            packedBytes[n2] = (byte)(packedBytes[n2] | (input[i] & mask[bits - empty_bits]) << 8 - bits + empty_bits);
            empty_bits += 8 - bits;
        }
        return packedBytes;
    }

    public static byte[] packByteArray(byte[] input, int stride, int start, int bits, int len) {
        if (bits == 8) {
            return ArrayUtils.subArray(input, start, len);
        }
        if (bits > 8 || bits <= 0) {
            throw new IllegalArgumentException("Invalid value of bits: " + bits);
        }
        int bitsPerStride = bits * stride;
        int numOfStrides = len / stride;
        byte[] packedBytes = new byte[(bitsPerStride + 7 >> 3) * numOfStrides];
        short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
        int index = 0;
        int empty_bits = 8;
        int end = start + len;
        int strideCounter = 0;
        for (int i = start; i < end; ++i) {
            if (empty_bits >= bits) {
                int n = index;
                packedBytes[n] = (byte)(packedBytes[n] | (input[i] & mask[bits]) << empty_bits - bits);
                empty_bits -= bits;
            } else {
                int n = index++;
                packedBytes[n] = (byte)(packedBytes[n] | input[i] >> bits - empty_bits & mask[empty_bits]);
                int n2 = index;
                packedBytes[n2] = (byte)(packedBytes[n2] | (input[i] & mask[bits - empty_bits]) << 8 - bits + empty_bits);
                empty_bits += 8 - bits;
            }
            if (++strideCounter % stride != 0 && empty_bits != 0) continue;
            ++index;
            empty_bits = 8;
        }
        return packedBytes;
    }

    public static void quicksort(int[] array) {
        ArrayUtils.quicksort(array, 0, array.length - 1);
    }

    public static void quicksort(int[] array, int start, int end) {
        int inner = start;
        int outer = end;
        int mid = (start + end) / 2;
        while (true) {
            if (inner < mid && array[inner] <= array[mid]) {
                ++inner;
                continue;
            }
            while (outer > mid && array[outer] >= array[mid]) {
                --outer;
            }
            if (inner < mid && outer > mid) {
                ArrayUtils.swap(array, inner, outer);
                ++inner;
                --outer;
            } else if (inner < mid) {
                ArrayUtils.swap(array, inner, mid - 1);
                ArrayUtils.swap(array, mid, mid - 1);
                --mid;
            } else if (outer > mid) {
                ArrayUtils.swap(array, outer, mid + 1);
                ArrayUtils.swap(array, mid, mid + 1);
                ++mid;
            }
            if (inner == outer) break;
        }
        if (mid - 1 > start) {
            ArrayUtils.quicksort(array, start, mid - 1);
        }
        if (end > mid + 1) {
            ArrayUtils.quicksort(array, mid + 1, end);
        }
    }

    public static <T extends Comparable<? super T>> void quicksort(T[] array) {
        ArrayUtils.quicksort(array, (int)0, (int)(array.length - 1));
    }

    public static <T extends Comparable<? super T>> void quicksort(T[] array, int low, int high) {
        int i = low;
        int j = high;
        T pivot = array[low + (high - low) / 2];
        while (i <= j) {
            while (array[i].compareTo(pivot) < 0) {
                ++i;
            }
            while (array[j].compareTo(pivot) > 0) {
                --j;
            }
            if (i > j) continue;
            ArrayUtils.swap(array, i, j);
            ++i;
            --j;
        }
        if (low < j) {
            ArrayUtils.quicksort(array, (int)low, (int)j);
        }
        if (i < high) {
            ArrayUtils.quicksort(array, (int)i, (int)high);
        }
    }

    public static int[] removeDuplicates(int[] input) {
        if (input.length < 2) {
            return input;
        }
        Arrays.sort(input);
        int j = 0;
        int i = 1;
        while (i < input.length) {
            if (input[i] == input[j]) {
                ++i;
                continue;
            }
            input[++j] = input[i++];
        }
        int[] output = new int[j + 1];
        System.arraycopy(input, 0, output, 0, j + 1);
        return output;
    }

    public static void reverseBits(byte[] input) {
        for (int i = input.length - 1; i >= 0; --i) {
            input[i] = BIT_REVERSE_TABLE[input[i] & 0xFF];
        }
    }

    public static byte[] reverse(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Input array is null");
        }
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            byte tmp = array[right];
            array[right] = array[left];
            array[left] = tmp;
        }
        return array;
    }

    public static <T> void reverse(T[] data) {
        int left = 0;
        for (int right = data.length - 1; left < right; ++left, --right) {
            T temp = data[left];
            data[left] = data[right];
            data[right] = temp;
        }
    }

    public static void shellsort(int[] array) {
        ArrayUtils.shellsort(array, 0, array.length - 1);
    }

    public static void shellsort(int[] array, int start, int end) {
        if (start < 0 || end < 0 || start > end || end > array.length - 1) {
            throw new IllegalArgumentException("Array index out of bounds");
        }
        int gap = 1;
        int len = end - start + 1;
        while (gap < len) {
            gap = 3 * gap + 1;
        }
        while (gap > 0) {
            int begin;
            for (int i = begin = start + gap; i <= end; ++i) {
                int temp = array[i];
                for (int j = i; j >= begin && temp <= array[j - gap]; j -= gap) {
                    array[j] = array[j - gap];
                }
                array[j] = temp;
            }
            gap /= 3;
        }
    }

    public static <T extends Comparable<? super T>> void shellsort(T[] array) {
        ArrayUtils.shellsort(array, (int)0, (int)(array.length - 1));
    }

    public static <T extends Comparable<? super T>> void shellsort(T[] array, int start, int end) {
        if (start < 0 || end < 0 || start > end || end > array.length - 1) {
            throw new IllegalArgumentException("Array index out of bounds");
        }
        int gap = 1;
        int len = end - start + 1;
        while (gap < len) {
            gap = 3 * gap + 1;
        }
        while (gap > 0) {
            int begin;
            for (int i = begin = start + gap; i <= end; ++i) {
                T temp = array[i];
                for (int j = i; j >= begin && temp.compareTo(array[j - gap]) <= 0; j -= gap) {
                    array[j] = array[j - gap];
                }
                array[j] = temp;
            }
            gap /= 3;
        }
    }

    public static byte[] subArray(byte[] src, int offset, int len) {
        if (offset == 0 && len == src.length) {
            return src;
        }
        if (offset < 0 || offset >= src.length || offset + len > src.length) {
            throw new IllegalArgumentException("Copy range out of array bounds");
        }
        byte[] dest = new byte[len];
        System.arraycopy(src, offset, dest, 0, len);
        return dest;
    }

    private static final void swap(int[] array, int a, int b) {
        int temp = array[a];
        array[a] = array[b];
        array[b] = temp;
    }

    private static final <T> void swap(T[] array, int a, int b) {
        T temp = array[a];
        array[a] = array[b];
        array[b] = temp;
    }

    public static float[] to16BitFloatArray(byte[] data, boolean bigEndian) {
        short[] shorts = (short[])ArrayUtils.toNBits(16, data, Integer.MAX_VALUE, bigEndian);
        float[] floats = new float[shorts.length];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = ArrayUtils.toFloat(shorts[i]);
        }
        return floats;
    }

    public static float[] to24BitFloatArray(byte[] data, boolean bigEndian) {
        int[] ints = (int[])ArrayUtils.toNBits(24, data, Integer.MAX_VALUE, bigEndian);
        float[] floats = new float[ints.length];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = Float.intBitsToFloat(ints[i] << 8);
        }
        return floats;
    }

    public static int[] to32BitsLongArray(byte[] data, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        LongBuffer longBuf = byteBuffer.asLongBuffer();
        long[] array = new long[longBuf.remaining()];
        longBuf.get(array);
        int[] iArray = new int[array.length];
        int i = 0;
        for (long l : array) {
            iArray[i++] = (int)l;
        }
        return iArray;
    }

    public static byte[] toByteArray(int value) {
        return new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24)};
    }

    public static byte[] toByteArray(int[] data, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length * 4);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(data);
        byte[] array = byteBuffer.array();
        return array;
    }

    public static byte[] toByteArray(long[] data, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length * 8);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.put(data);
        byte[] array = byteBuffer.array();
        return array;
    }

    public static byte[] toByteArray(short value) {
        return new byte[]{(byte)value, (byte)(value >>> 8)};
    }

    public static byte[] toByteArray(short[] data, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length * 2);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        shortBuffer.put(data);
        byte[] array = byteBuffer.array();
        return array;
    }

    public static byte[] toByteArrayMM(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static byte[] toByteArrayMM(short value) {
        return new byte[]{(byte)(value >>> 8), (byte)value};
    }

    public static double[] toDoubleArray(byte[] data, boolean bigEndian) {
        return ArrayUtils.toDoubleArray(data, 0, data.length, bigEndian);
    }

    public static double[] toDoubleArray(byte[] data, int offset, int len, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, len);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        DoubleBuffer doubleBuf = byteBuffer.asDoubleBuffer();
        double[] array = new double[doubleBuf.remaining()];
        doubleBuf.get(array);
        return array;
    }

    public static float toFloat(int lbits) {
        int mant = lbits & 0x3FF;
        int exp = lbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((lbits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((lbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    public static float[] toFloatArray(byte[] data, boolean bigEndian) {
        return ArrayUtils.toFloatArray(data, 0, data.length, bigEndian);
    }

    public static float[] toFloatArray(byte[] data, int offset, int len, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, len);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        FloatBuffer floatBuf = byteBuffer.asFloatBuffer();
        float[] array = new float[floatBuf.remaining()];
        floatBuf.get(array);
        return array;
    }

    public static int[] toIntArray(byte[] data, boolean bigEndian) {
        return ArrayUtils.toIntArray(data, 0, data.length, bigEndian);
    }

    public static int[] toIntArray(byte[] data, int offset, int len, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, len);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        IntBuffer intBuf = byteBuffer.asIntBuffer();
        int[] array = new int[intBuf.remaining()];
        intBuf.get(array);
        return array;
    }

    public static long[] toLongArray(byte[] data, boolean bigEndian) {
        return ArrayUtils.toLongArray(data, 0, data.length, bigEndian);
    }

    public static long[] toLongArray(byte[] data, int offset, int len, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, len);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        LongBuffer longBuf = byteBuffer.asLongBuffer();
        long[] array = new long[longBuf.remaining()];
        longBuf.get(array);
        return array;
    }

    public static Object toNBits(int nBits, byte[] input, int stride, boolean bigEndian) {
        int value = 0;
        int bits_remain = 0;
        int temp_byte = 0;
        byte[] byteOutput = null;
        short[] shortOutput = null;
        int[] intOutput = null;
        Object[] output = null;
        int outLen = (int)(((long)input.length * 8L + (long)nBits - 1L) / (long)nBits);
        if (nBits <= 8) {
            output = byteOutput = new byte[outLen];
        } else if (nBits <= 16) {
            shortOutput = new short[outLen];
            output = shortOutput;
        } else if (nBits <= 32) {
            intOutput = new int[outLen];
            output = intOutput;
        } else {
            throw new IllegalArgumentException("nBits exceeds limit - maximum 32");
        }
        int offset = 0;
        int index = 0;
        int strideCounter = 0;
        block0: while (true) {
            value = !bigEndian ? temp_byte >> 8 - bits_remain : temp_byte & MASK[bits_remain];
            while (nBits > bits_remain) {
                if (offset >= input.length) break block0;
                temp_byte = input[offset++] & 0xFF;
                value = bigEndian ? value << 8 | temp_byte : (value |= temp_byte << bits_remain);
                bits_remain += 8;
            }
            bits_remain -= nBits;
            if (bigEndian) {
                value >>= bits_remain;
            }
            value &= MASK[nBits];
            if (++strideCounter % stride == 0) {
                bits_remain = 0;
            }
            if (nBits <= 8) {
                byteOutput[index++] = (byte)value;
                continue;
            }
            if (nBits <= 16) {
                shortOutput[index++] = (short)value;
                continue;
            }
            intOutput[index++] = value;
        }
        return output;
    }

    public static double[] toPrimitive(Double[] doubles) {
        double[] dArray = new double[doubles.length];
        int i = 0;
        Double[] doubleArray = doubles;
        int n = doubleArray.length;
        for (int j = 0; j < n; ++j) {
            double d = doubleArray[j];
            dArray[i++] = d;
        }
        return dArray;
    }

    public static float[] toPrimitive(Float[] floats) {
        float[] fArray = new float[floats.length];
        int i = 0;
        Float[] floatArray = floats;
        int n = floatArray.length;
        for (int j = 0; j < n; ++j) {
            float f = floatArray[j].floatValue();
            fArray[i++] = f;
        }
        return fArray;
    }

    public static int[] toPrimitive(Integer[] integers) {
        int[] ints = new int[integers.length];
        int i = 0;
        Integer[] integerArray = integers;
        int n = integerArray.length;
        for (int j = 0; j < n; ++j) {
            int n2 = integerArray[j];
            ints[i++] = n2;
        }
        return ints;
    }

    public static long[] toPrimitive(Long[] longs) {
        long[] lArray = new long[longs.length];
        int i = 0;
        Long[] longArray = longs;
        int n = longArray.length;
        for (int j = 0; j < n; ++j) {
            long l = longArray[j];
            lArray[i++] = l;
        }
        return lArray;
    }

    public static short[] toPrimitive(Short[] shorts) {
        short[] sArray = new short[shorts.length];
        int i = 0;
        Short[] shortArray = shorts;
        int n = shortArray.length;
        for (int j = 0; j < n; ++j) {
            short s = shortArray[j];
            sArray[i++] = s;
        }
        return sArray;
    }

    public static short[] toShortArray(byte[] data, boolean bigEndian) {
        return ArrayUtils.toShortArray(data, 0, data.length, bigEndian);
    }

    public static short[] toShortArray(byte[] data, int offset, int len, boolean bigEndian) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, len);
        if (bigEndian) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        ShortBuffer shortBuf = byteBuffer.asShortBuffer();
        short[] array = new short[shortBuf.remaining()];
        shortBuf.get(array);
        return array;
    }

    public static byte[] trim(byte[] input) {
        try {
            return new String(input, "UTF-8").trim().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    private ArrayUtils() {
    }
}

