/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.cafe4j.util.BinaryTreeNode;

public class BinarySearchTree<E extends Comparable<? super E>> {
    private BinaryTreeNode<E> root = null;

    public void insert(E val) {
        this.root = this.insert(val, this.root);
    }

    public void remove(E val) {
        this.root = this.remove(val, this.root);
    }

    public void removeMinItem() {
        this.root = this.removeMinItem(this.root);
    }

    public E findMinItem() {
        return this.valueOf(this.findMinItem(this.root));
    }

    public E findMaxItem() {
        return this.valueOf(this.findMaxItem(this.root));
    }

    public E find(E val) {
        return this.valueOf(this.find(val, this.root));
    }

    public void makeEmpty() {
        this.root = null;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    E valueOf(BinaryTreeNode<E> n) {
        return (E)(n == null ? null : (Comparable)n.val);
    }

    BinaryTreeNode<E> insert(E val, BinaryTreeNode<E> n) {
        if (n == null) {
            n = new BinaryTreeNode<E>(val);
        } else {
            BinaryTreeNode<E> parent = null;
            BinaryTreeNode<E> curr = n;
            while (curr != null && val.compareTo(curr.val) != 0) {
                parent = curr;
                curr = val.compareTo(curr.val) < 0 ? curr.left : curr.right;
            }
            if (curr != null) {
                ++curr.freq;
            } else if (val.compareTo(parent.val) < 0) {
                parent.left = new BinaryTreeNode<E>(val);
            } else {
                parent.right = new BinaryTreeNode<E>(val);
            }
        }
        return n;
    }

    BinaryTreeNode<E> remove(E val, BinaryTreeNode<E> n) {
        BinaryTreeNode<E> parent = null;
        BinaryTreeNode<E> curr = n;
        while (curr != null && val.compareTo(curr.val) != 0) {
            parent = curr;
            curr = val.compareTo(curr.val) < 0 ? curr.left : curr.right;
        }
        if (curr != null) {
            if (curr.left != null && curr.right != null) {
                BinaryTreeNode pre = null;
                BinaryTreeNode t = curr.right;
                while (t.left != null) {
                    pre = t;
                    t = t.left;
                }
                if (pre == null) {
                    curr.val = curr.right.val;
                    curr.right = curr.right.right;
                } else {
                    curr.val = pre.left.val;
                    pre.left = pre.left.right;
                }
            } else if (parent != null) {
                if (((Comparable)curr.val).compareTo(parent.val) < 0) {
                    parent.left = curr.left != null ? curr.left : curr.right;
                } else {
                    parent.right = curr.left != null ? curr.left : curr.right;
                }
            } else {
                return curr.left != null ? curr.left : curr.right;
            }
        }
        return n;
    }

    BinaryTreeNode<E> removeMinItem(BinaryTreeNode<E> n) {
        if (n == null) {
            return null;
        }
        BinaryTreeNode<E> parent = null;
        BinaryTreeNode<E> curr = n;
        while (curr.left != null) {
            parent = curr;
            curr = curr.left;
        }
        if (parent != null) {
            parent.left = parent.left.right;
            return n;
        }
        return n.right;
    }

    BinaryTreeNode<E> findMinItem(BinaryTreeNode<E> n) {
        if (n != null) {
            while (n.left != null) {
                n = n.left;
            }
        }
        return n;
    }

    BinaryTreeNode<E> findMaxItem(BinaryTreeNode<E> n) {
        if (n != null) {
            while (n.right != null) {
                n = n.right;
            }
        }
        return n;
    }

    BinaryTreeNode<E> find(E val, BinaryTreeNode<E> n) {
        while (n != null && val.compareTo(n.val) != 0) {
            n = val.compareTo(n.val) < 0 ? n.left : n.right;
        }
        return n;
    }

    public static void main(String[] args) {
        BinarySearchTree<Integer> t = new BinarySearchTree<Integer>();
        int NUMS = 4000;
        int GAP = 37;
        System.out.println("Checking... (no more output means success)");
        int i = 37;
        while (i != 0) {
            t.insert(new Integer(i));
            i = (i + 37) % 4000;
        }
        for (i = 1; i < 4000; i += 2) {
            t.remove(new Integer(i));
        }
        if ((Integer)t.findMinItem() != 2 || (Integer)t.findMaxItem() != 3998) {
            System.out.println("FindMin or FindMax error!");
        }
        for (i = 2; i < 4000; i += 2) {
            if (t.find(new Integer(i)) == i) continue;
            System.out.println("Find error1!");
        }
        for (i = 1; i < 4000; i += 2) {
            if (t.find(new Integer(i)) == null) continue;
            System.out.println("Find error2!");
        }
    }
}

