/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.cafe4j.util.DoublyLinkedListNode;
import java.lang.reflect.Array;

public class DoublyLinkedList<E> {
    private int count;
    private DoublyLinkedListNode<E> head;
    private DoublyLinkedListNode<E> tail;
    private final DoublyLinkedListNode<E> SENTINEL1 = new DoublyLinkedListNode<Object>(null);
    private final DoublyLinkedListNode<E> SENTINEL2 = new DoublyLinkedListNode<Object>(null);

    public DoublyLinkedList() {
        this.clear();
    }

    public void addToHead(E value) {
        DoublyLinkedListNode<E> temp = new DoublyLinkedListNode<E>(value, this.head, this.head.next());
        this.head.setNext(temp);
        temp.next().setPrev(temp);
        ++this.count;
    }

    public void add(E value) {
        this.addToHead(value);
    }

    public E removeFromHead() {
        E value = null;
        if (!this.isEmpty()) {
            DoublyLinkedListNode<E> temp = this.head.next();
            this.head.setNext(temp.next());
            temp.next().setPrev(this.head);
            value = temp.getValue();
            --this.count;
        }
        return value;
    }

    public E remove() {
        return this.removeFromHead();
    }

    public void addToTail(E value) {
        DoublyLinkedListNode<E> temp = new DoublyLinkedListNode<E>(value, this.tail.prev(), this.tail);
        this.tail.setPrev(temp);
        temp.prev().setNext(temp);
        ++this.count;
    }

    public E removeFromTail() {
        E value = null;
        if (!this.isEmpty()) {
            DoublyLinkedListNode<E> temp = this.tail.prev();
            this.tail.setPrev(temp.prev());
            temp.prev().setNext(this.tail);
            value = temp.getValue();
            --this.count;
        }
        return value;
    }

    public E peekHead() {
        return !this.isEmpty() ? (E)this.head.next().getValue() : null;
    }

    public E peekTail() {
        return !this.isEmpty() ? (E)this.tail.prev().getValue() : null;
    }

    public boolean contains(E value) {
        DoublyLinkedListNode<E> temp;
        for (temp = this.head.next(); temp != null && !temp.getValue().equals(value); temp = temp.next()) {
        }
        return temp != null;
    }

    public E remove(E value) {
        DoublyLinkedListNode<E> temp;
        DoublyLinkedListNode<E> prev = this.head;
        for (temp = this.head.next(); temp != null && !temp.getValue().equals(value); temp = temp.next()) {
            prev = temp;
        }
        if (temp != null) {
            prev.setNext(temp.next());
            if (temp.next() != null) {
                temp.next().setPrev(prev);
            }
            --this.count;
            return temp.getValue();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public E[] toArray(E[] a) {
        if (a.length < this.count) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
        }
        int i = 0;
        for (DoublyLinkedListNode<E> e = this.head.next(); e != this.tail; e = e.next()) {
            a[i++] = e.getValue();
        }
        if (a.length > this.count) {
            a[this.count] = null;
        }
        return a;
    }

    public void transferList(DoublyLinkedList<E> list) {
        list.head = this.head;
        list.tail = this.tail;
        list.count = this.count;
        this.clear();
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.head = this.SENTINEL1;
        this.tail = this.SENTINEL2;
        this.head.setNext(this.tail);
        this.tail.setPrev(this.head);
        this.count = 0;
    }

    public static void main(String[] args) {
        int i;
        DoublyLinkedList<Integer> list = new DoublyLinkedList<Integer>();
        int NUMS = 4000;
        System.out.println("Checking... (no more output means success)");
        for (i = 0; i < 4000; ++i) {
            list.addToTail(new Integer(i));
        }
        for (i = 3999; i > 0; --i) {
            if ((Integer)list.peekTail() != i) {
                System.out.println("peekHead() error!");
            }
            if ((Integer)list.removeFromTail() == i) continue;
            System.out.println("removdeFromHead() error!");
        }
        list.clear();
        for (i = 0; i < 4000; ++i) {
            list.addToTail(new Integer(i));
        }
        for (i = 0; i < 4000; ++i) {
            if ((Integer)list.peekHead() != i) {
                System.out.println("peekHead() error!");
            }
            if ((Integer)list.removeFromHead() == i) continue;
            System.out.println("removdeFromHead() error!");
        }
    }
}

