/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

public class ExternalChainingHashTable<K, V> {
    private static final int DEFAULT_TABLE_SIZE = 101;
    private int currentSize = 0;
    private HashEntry<K, V>[] entries;

    public ExternalChainingHashTable() {
        this(101);
    }

    public ExternalChainingHashTable(int size) {
        this.entries = new HashEntry[ExternalChainingHashTable.nextPrime(size)];
    }

    public void put(K key, V value) {
        int hash = key.hashCode();
        int currentPos = (hash & Integer.MAX_VALUE) % this.entries.length;
        HashEntry<K, V> e = this.entries[currentPos];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return;
            }
            e = e.next;
        }
        this.entries[currentPos] = e = new HashEntry<K, V>(hash, key, value, this.entries[currentPos]);
        if (++this.currentSize > this.entries.length / 2) {
            this.rehash();
        }
    }

    public void remove(K key) {
        int hash = key.hashCode();
        int currentPos = (hash & Integer.MAX_VALUE) % this.entries.length;
        HashEntry<K, V> prev = null;
        HashEntry<K, V> e = this.entries[currentPos];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    this.entries[currentPos] = e.next;
                }
                --this.currentSize;
            }
            prev = e;
            e = e.next;
        }
    }

    public V get(K key) {
        int hash = key.hashCode();
        int currentPos = (hash & Integer.MAX_VALUE) % this.entries.length;
        HashEntry<K, V> e = this.entries[currentPos];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean contains(K key) {
        int hash = key.hashCode();
        int currentPos = (hash & Integer.MAX_VALUE) % this.entries.length;
        HashEntry<K, V> e = this.entries[currentPos];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private void rehash() {
        HashEntry<K, V>[] oldEntries = this.entries;
        this.entries = new HashEntry[ExternalChainingHashTable.nextPrime(2 * oldEntries.length)];
        for (int i = 0; i < oldEntries.length; ++i) {
            HashEntry<K, V> e = oldEntries[i];
            while (e != null) {
                HashEntry<K, V> cursor = e;
                e = e.next;
                int currentPos = (cursor.hash & Integer.MAX_VALUE) % this.entries.length;
                cursor.next = this.entries[currentPos];
                this.entries[currentPos] = cursor;
            }
        }
    }

    public static int hashString(String key, int tableSize) {
        int hashVal = 0;
        for (int i = 0; i < key.length(); ++i) {
            hashVal = 37 * hashVal + key.charAt(i);
        }
        if ((hashVal %= tableSize) < 0) {
            hashVal += tableSize;
        }
        return hashVal;
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!ExternalChainingHashTable.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public static void main(String[] args) {
        ExternalChainingHashTable<Integer, Integer> H = new ExternalChainingHashTable<Integer, Integer>();
        int NUMS = 4000;
        int GAP = 37;
        System.out.println("Checking... (no more output means success)");
        int i = 37;
        while (i != 0) {
            H.put(i, i);
            i = (i + 37) % 4000;
        }
        for (i = 1; i < 4000; i += 2) {
            H.remove(i);
        }
        for (i = 2; i < 4000; i += 2) {
            if ((Integer)H.get(i) == i) continue;
            System.out.println("Find fails " + i);
        }
        for (i = 1; i < 4000; i += 2) {
            if (H.get(i) == null) continue;
            System.out.println("OOPS!!! " + i);
        }
    }

    private static class HashEntry<K, V> {
        int hash;
        K key;
        V value;
        HashEntry<K, V> next;

        HashEntry(int hash, K key, V value, HashEntry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

