/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static void delete(String fileName) {
        FileUtils.delete(fileName, "");
    }

    public static void delete(String fileName, String fileExt) {
        File file = new File(fileName);
        FileUtils.delete(file, fileExt);
    }

    public static String getNameWithoutExtension(File file) {
        return file.getName().replaceFirst("[.][^.]+$", "");
    }

    public static void delete(File file, String fileExt) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    FileUtils.delete(f, fileExt);
                }
            } else {
                String path = file.getAbsolutePath();
                if (fileExt != null && path.endsWith(fileExt)) {
                    boolean result = file.delete();
                    if (result) {
                        LOGGER.info("File {} deleted", (Object)file.getAbsolutePath());
                    } else {
                        LOGGER.info("File {} was not deleted, unknown reason", (Object)file.getAbsolutePath());
                    }
                }
            }
        } else {
            LOGGER.info("File {} doesn't exist", (Object)file.getAbsolutePath());
        }
    }

    public static List<String> list(String dir) {
        return FileUtils.list(dir, "");
    }

    public static List<String> list(String dir, String fileExt) {
        File file = new File(dir);
        return FileUtils.list(file, fileExt);
    }

    public static List<String> list(File dir, String fileExt) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (dir.isDirectory()) {
            File[] files;
            for (File f : files = dir.listFiles()) {
                FileUtils.list(f, fileExt);
            }
        } else {
            String path = "";
            try {
                path = dir.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("IOException", e);
            }
            if (fileExt != null && path.endsWith(fileExt)) {
                fileList.add(path);
                LOGGER.info("File: {}", (Object)path);
            }
        }
        return fileList;
    }

    public static File[] listFilesMatching(File root, String regex) {
        if (!root.isDirectory()) {
            throw new IllegalArgumentException(root + " is not a directory.");
        }
        final Pattern p = Pattern.compile(regex);
        return root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return p.matcher(file.getName()).matches();
            }
        });
    }

    private FileUtils() {
    }
}

