/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.lang.reflect.Array;

public class GrowableArray<E> {
    private transient E[] objarray;
    private int increment;
    private int elements;
    private int initsize;
    private static final Logger LOGGER = LoggerFactory.getLogger(GrowableArray.class);

    public GrowableArray(int inisize, int inc) {
        if (inisize <= 0) {
            inisize = 10;
        }
        if (inc <= 0) {
            inc = 5;
        }
        this.initsize = inisize;
        this.objarray = new Object[inisize];
        this.increment = inc;
        this.elements = 0;
    }

    public int getSize() {
        return this.elements;
    }

    public E[] toArray(E[] a) {
        if (a.length < this.elements) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.elements);
        }
        System.arraycopy(this.objarray, 0, a, 0, this.elements);
        if (a.length > this.elements) {
            a[this.elements] = null;
        }
        return a;
    }

    public void shrink() {
        int oldCapacity = this.objarray.length;
        if (this.elements < oldCapacity) {
            E[] temp = this.objarray;
            this.objarray = new Object[this.elements];
            System.arraycopy(temp, 0, this.objarray, 0, this.elements);
        }
    }

    public void printArray() {
        LOGGER.info("Size is {}.", (Object)String.valueOf(this.elements));
        for (int i = 0; i < this.elements; ++i) {
            LOGGER.info("Position [{}] = {}", (Object)String.valueOf(i), (Object)String.valueOf(this.objarray[i]));
        }
    }

    public E getElement(int j) {
        if (0 <= j && j < this.elements) {
            return this.objarray[j];
        }
        throw new ArrayIndexOutOfBoundsException(j);
    }

    public boolean setElement(int j, E o) {
        if (0 <= j && j < this.elements) {
            this.objarray[j] = o;
            return true;
        }
        throw new ArrayIndexOutOfBoundsException(j);
    }

    public E removeArrayElement(int j) {
        if (this.elements >= 1 && 0 <= j && j < this.elements) {
            E oldValue = this.objarray[j];
            System.arraycopy(this.objarray, j + 1, this.objarray, j, this.elements - j - 1);
            --this.elements;
            this.objarray[this.elements] = null;
            return oldValue;
        }
        throw new ArrayIndexOutOfBoundsException(j);
    }

    public E removeArrayElement(E o) {
        int pointer = -1;
        for (int i = 0; i < this.elements; ++i) {
            if (!o.equals(this.objarray[i])) continue;
            pointer = i;
            break;
        }
        if (pointer != -1) {
            return this.removeArrayElement((E)pointer);
        }
        return null;
    }

    public void addArrayElement(E o) {
        this.checkCapacity(this.elements + 1);
        this.objarray[this.elements++] = o;
    }

    public void insertArrayElement(int j, E o) {
        if (0 <= j && j <= this.elements) {
            this.checkCapacity(this.elements + 1);
            System.arraycopy(this.objarray, j, this.objarray, j + 1, this.elements - j);
            this.objarray[j] = o;
            ++this.elements;
        } else {
            throw new ArrayIndexOutOfBoundsException(j);
        }
    }

    private void checkCapacity(int capacityRequired) {
        int oldCapacity = this.objarray.length;
        if (capacityRequired > oldCapacity) {
            E[] temp = this.objarray;
            int newCapacity = this.increment > 0 ? oldCapacity + this.increment : oldCapacity * 2;
            this.objarray = new Object[newCapacity];
            System.arraycopy(temp, 0, this.objarray, 0, this.elements);
        }
    }

    public void clear() {
        for (int i = 0; i < this.elements; ++i) {
            this.objarray[i] = null;
        }
        this.objarray = new Object[this.initsize];
        this.elements = 0;
    }
}

