/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

public class IntHashtable<E> {
    private static final int DEFAULT_TABLE_SIZE = 257;
    private HashEntry<E>[] array;
    private int currentSize;

    public IntHashtable() {
        this(257);
    }

    public IntHashtable(int size) {
        this.array = new HashEntry[size];
        this.makeEmpty();
    }

    public void put(int key, E value) {
        int currentPos = this.locate(key);
        if (this.isActive(currentPos)) {
            return;
        }
        this.array[currentPos] = new HashEntry<E>(key, value, true);
        if (++this.currentSize > this.array.length / 2) {
            this.rehash();
        }
    }

    private void rehash() {
        HashEntry<E>[] oldArray = this.array;
        this.array = new HashEntry[IntHashtable.nextPrime(2 * oldArray.length)];
        this.currentSize = 0;
        for (int i = 0; i < oldArray.length; ++i) {
            if (oldArray[i] == null || !oldArray[i].isActive) continue;
            this.put(oldArray[i].key, oldArray[i].value);
        }
    }

    private int locate(int key) {
        int collisionNum = 0;
        int currentPos = (key & Integer.MAX_VALUE) % this.array.length;
        while (this.array[currentPos] != null && this.array[currentPos].key != key) {
            if ((currentPos += 2 * ++collisionNum - 1) < this.array.length) continue;
            currentPos -= this.array.length;
        }
        return currentPos;
    }

    public void remove(int key) {
        int currentPos = this.locate(key);
        if (this.isActive(currentPos)) {
            this.array[currentPos].isActive = false;
            --this.currentSize;
        }
    }

    public boolean contains(int key) {
        return this.isActive(this.locate(key));
    }

    public E get(int key) {
        int currentPos = this.locate(key);
        return this.isActive(currentPos) ? (E)this.array[currentPos].value : null;
    }

    private boolean isActive(int currentPos) {
        return this.array[currentPos] != null && this.array[currentPos].isActive;
    }

    public void makeEmpty() {
        this.currentSize = 0;
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!IntHashtable.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public static void main(String[] args) {
        IntHashtable<Integer> H = new IntHashtable<Integer>();
        int NUMS = 4000;
        int GAP = 37;
        System.out.println("Checking... (no more output means success)");
        int i = 37;
        while (i != 0) {
            H.put(i, new Integer(i));
            i = (i + 37) % 4000;
        }
        for (i = 1; i < 4000; i += 2) {
            H.remove(i);
        }
        for (i = 2; i < 4000; i += 2) {
            if ((Integer)H.get(i) == i) continue;
            System.out.println("Find fails " + i);
        }
        for (i = 1; i < 4000; i += 2) {
            if (H.get(i) == null) continue;
            System.out.println("OOPS!!! " + i);
        }
    }

    private static class HashEntry<V> {
        int key;
        V value;
        boolean isActive;

        HashEntry(int k, V val) {
            this(k, val, true);
        }

        HashEntry(int k, V val, boolean i) {
            this.key = k;
            this.value = val;
            this.isActive = i;
        }
    }
}

