/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LRUCache<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 4874219673008997966L;
    private Map<K, V> map = null;

    public LRUCache() {
        this(10, false);
    }

    public LRUCache(boolean isThreadsafe) {
        this(10, isThreadsafe);
    }

    public LRUCache(final int limit, boolean isThreadsafe) {
        this.map = new LinkedHashMap<K, V>(16, 0.75f, true){
            private static final long serialVersionUID = 3195834455030574184L;

            @Override
            public boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > limit;
            }
        };
        if (isThreadsafe) {
            this.map = Collections.synchronizedMap(this.map);
        }
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

