/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.regex.Pattern;

public class LangUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LangUtils.class);

    private LangUtils() {
    }

    public static long[] doubleToRational(double number) {
        if (number == 0.0 || Double.isNaN(number)) {
            throw new IllegalArgumentException(number + " cannot be represented as a rational number");
        }
        long bits = Double.doubleToLongBits(number);
        long sign = bits >>> 63;
        long exponent = (bits >>> 52 ^ sign << 11) - 1023L;
        long fraction = bits << 12;
        long a = 1L;
        long b = 1L;
        for (int i = 63; i >= 12; --i) {
            a = a * 2L + (fraction >>> i & 1L);
            b *= 2L;
        }
        if (exponent > 0L) {
            a *= (long)(1 << (int)exponent);
        } else {
            b *= (long)(1 << (int)(-exponent));
        }
        if (sign == 1L) {
            a *= -1L;
        }
        return new long[]{a, b};
    }

    public static Annotation getAnnotation(AnnotatedElement element, String annotationTypeName) {
        Class<?> annotationType = null;
        try {
            annotationType = Class.forName(annotationTypeName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        return element.getAnnotation(annotationType.asSubclass(Annotation.class));
    }

    public static String getClassName(Class<?> c) {
        String name = c.getName().replace('$', '.');
        if (c.isArray()) {
            switch (name.charAt(1)) {
                case 'B': {
                    name = "byte";
                    break;
                }
                case 'C': {
                    name = "char";
                    break;
                }
                case 'D': {
                    name = "double";
                    break;
                }
                case 'F': {
                    name = "float";
                    break;
                }
                case 'I': {
                    name = "int";
                    break;
                }
                case 'J': {
                    name = "long";
                    break;
                }
                case 'L': {
                    name = name.substring(2, name.length() - 1);
                    break;
                }
                case 'S': {
                    name = "short";
                    break;
                }
                case 'Z': {
                    name = "boolean";
                }
            }
            name = name + "[]";
        }
        return name;
    }

    public static Type[] getGenericTypeArguments(Method m, int i) {
        try {
            Type t = m.getGenericParameterTypes()[i];
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                return pt.getActualTypeArguments();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error probing generic type arguments!", e);
        }
        return new Type[0];
    }

    public static void log(String message, PrintStream out) {
        StackTraceElement se = Thread.currentThread().getStackTrace()[2];
        out.println("; " + message + " - [" + se.getClassName() + "." + se.getMethodName() + "(): line " + se.getLineNumber() + "]");
    }

    public static URL getLoadedClassLocation(Class<?> cls) {
        ProtectionDomain pDomain = cls.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        URL loc = cSource == null ? null : cSource.getLocation();
        return loc;
    }

    public static URL getLoadedClassLocation(String className) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        return LangUtils.getLoadedClassLocation(cls);
    }

    public static URL getLoadedClassURL(String className) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        ClassLoader classLoader = cls.getClassLoader();
        URL url = classLoader.getResource(className.replaceAll(Pattern.quote("."), "/") + ".class");
        return url;
    }

    public static void invokeMain(String ... args) {
        try {
            Class<?> c = Class.forName(args[0]);
            Class<String[]> argTypes = String[].class;
            Method main = c.getDeclaredMethod("main", argTypes);
            String[] mainArgs = Arrays.copyOfRange(args, 1, args.length);
            LOGGER.info("invoking {}.main()\n", (Object)c.getName());
            main.invoke(null, new Object[]{mainArgs});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int longToIntHashCode(long value) {
        return Long.valueOf(value).hashCode();
    }

    public static URI relativize(URI base, URI child) {
        int j;
        int i;
        base = base.normalize();
        child = child.normalize();
        String[] bParts = base.getPath().split("/");
        String[] cParts = child.getPath().split("/");
        if (bParts.length > 0 && !base.getPath().endsWith("/")) {
            System.arraycopy(bParts, 0, bParts, 0, bParts.length - 1);
        }
        for (i = 0; i < bParts.length && i < cParts.length && bParts[i].equals(cParts[i]); ++i) {
        }
        StringBuilder sb = new StringBuilder();
        for (j = 0; j < bParts.length - i; ++j) {
            sb.append("../");
        }
        for (j = i; j < cParts.length; ++j) {
            if (j != i) {
                sb.append("/");
            }
            sb.append(cParts[j]);
        }
        return URI.create(sb.toString());
    }
}

