/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.cafe4j.util.LeftHeapNode;
import java.lang.reflect.Array;

public class LeftistHeap<E extends Comparable<? super E>> {
    private LeftHeapNode<E> root = null;
    private int size;

    public void merge(LeftistHeap<E> rhs) {
        if (this == rhs) {
            return;
        }
        this.root = LeftistHeap.merge(this.root, rhs.root);
        this.size += rhs.getSize();
        rhs.root = null;
    }

    private static <T extends Comparable<? super T>> LeftHeapNode<T> merge(LeftHeapNode<T> h1, LeftHeapNode<T> h2) {
        LeftHeapNode<Object> temp;
        if (h1 == null) {
            return h2;
        }
        if (h2 == null) {
            return h1;
        }
        if (((Comparable)h1.element).compareTo(h2.element) > 0) {
            temp = h1;
            h1 = h2;
            h2 = temp;
        }
        if (h1.left == null) {
            h1.left = h2;
        } else {
            h1.right = LeftistHeap.merge(h1.right, h2);
            if (h1.left.npl < h1.right.npl) {
                temp = h1.left;
                h1.left = h1.right;
                h1.right = temp;
            }
            h1.npl = h1.right.npl + 1;
        }
        return h1;
    }

    public synchronized void insert(E x) {
        this.root = LeftistHeap.merge(this.root, new LeftHeapNode<E>(x));
        ++this.size;
    }

    public synchronized E findMin() {
        return (E)(this.root == null ? null : (Comparable)this.root.element);
    }

    public synchronized E deleteMin() {
        if (this.root == null) {
            return null;
        }
        Comparable minItem = (Comparable)this.root.element;
        this.root = LeftistHeap.merge(this.root.left, this.root.right);
        --this.size;
        return (E)minItem;
    }

    public synchronized E[] toArray(E[] a, boolean incr) {
        int capacity = this.size;
        if (a.length < capacity) {
            a = (Comparable[])Array.newInstance(a.getClass().getComponentType(), capacity);
        }
        if (incr) {
            for (int i = 0; i < capacity; ++i) {
                a[i] = this.deleteMin();
            }
        } else {
            int i = capacity;
            while (i-- > 0) {
                a[i] = this.deleteMin();
            }
        }
        if (a.length > capacity) {
            a[capacity] = null;
        }
        return a;
    }

    public synchronized boolean isEmpty() {
        return this.root == null;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized void makeEmpty() {
        this.root = null;
    }

    public static void main(String[] args) {
        int numItems = 100;
        LeftistHeap<Integer> h = new LeftistHeap<Integer>();
        LeftistHeap<Integer> h1 = new LeftistHeap<Integer>();
        int i = 37;
        System.out.println("Checking... (no more output means success)");
        i = 37;
        while (i != 0) {
            if (i % 2 == 0) {
                h1.insert(i);
            } else {
                h.insert(i);
            }
            i = (i + 37) % numItems;
        }
        h.merge(h1);
        for (i = 1; i < numItems; ++i) {
            if ((Integer)h.deleteMin() == i) continue;
            System.out.println("Oops! " + i);
        }
    }
}

