/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.cafe4j.util.LinkedListItr;
import guilibshadow.cafe4j.util.ListNode;

public class LinkedList<E> {
    private ListNode<E> header = new ListNode<Object>(null);

    public boolean isEmpty() {
        return this.header.next == null;
    }

    public void makeEmpty() {
        this.header.next = null;
    }

    public LinkedListItr<E> zeroth() {
        return new LinkedListItr<E>(this.header);
    }

    public LinkedListItr<E> first() {
        return new LinkedListItr(this.header.next);
    }

    public void insert(E x, LinkedListItr<E> p) {
        if (p != null && p.current != null) {
            p.current.next = new ListNode<E>(x, p.current.next);
        }
    }

    public LinkedListItr<E> find(E x) {
        ListNode itr = this.header.next;
        while (itr != null && !itr.element.equals(x)) {
            itr = itr.next;
        }
        return new LinkedListItr(itr);
    }

    public LinkedListItr<E> findPrevious(E x) {
        ListNode<E> itr = this.header;
        while (itr.next != null && !itr.next.element.equals(x)) {
            itr = itr.next;
        }
        return new LinkedListItr<E>(itr);
    }

    public void remove(E x) {
        LinkedListItr<E> p = this.findPrevious(x);
        if (p.current.next != null) {
            p.current.next = p.current.next.next;
        }
    }

    private static <T> void printList(LinkedList<T> theList) {
        if (theList.isEmpty()) {
            System.out.print("Empty list");
        } else {
            LinkedListItr<T> itr = theList.first();
            while (!itr.isPastEnd()) {
                System.out.print(itr.retrieve() + " ");
                itr.advance();
            }
        }
        System.out.println();
    }

    public static void main(String[] args) {
        int i;
        LinkedList<Integer> theList = new LinkedList<Integer>();
        LinkedListItr theItr = theList.zeroth();
        LinkedList.printList(theList);
        for (i = 0; i < 10; ++i) {
            theList.insert(i, theItr);
            LinkedList.printList(theList);
            theItr.advance();
        }
        for (i = 0; i < 10; i += 2) {
            theList.remove(i);
        }
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0 == theList.find(i).isPastEnd()) continue;
            System.out.println("Find fails!");
        }
        System.out.println("Finished deletions");
        LinkedList.printList(theList);
    }
}

