/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.cafe4j.util.LinkedList;
import guilibshadow.cafe4j.util.LinkedListItr;

public class SeparateChainingHashTable<E> {
    private static final int DEFAULT_TABLE_SIZE = 101;
    private LinkedList<E>[] theLists;

    public SeparateChainingHashTable() {
        this(101);
    }

    public SeparateChainingHashTable(int size) {
        this.theLists = new LinkedList[SeparateChainingHashTable.nextPrime(size)];
        for (int i = 0; i < this.theLists.length; ++i) {
            this.theLists[i] = new LinkedList();
        }
    }

    public void put(E x) {
        int hash = x.hashCode();
        int currentPos = (hash & Integer.MAX_VALUE) % this.theLists.length;
        LinkedList<E> whichList = this.theLists[currentPos];
        LinkedListItr<E> itr = whichList.find(x);
        if (itr.isPastEnd()) {
            whichList.insert(x, whichList.zeroth());
        }
    }

    public void remove(E x) {
        int hash = x.hashCode();
        int currentPos = (hash & Integer.MAX_VALUE) % this.theLists.length;
        this.theLists[currentPos].remove(x);
    }

    public E get(E x) {
        return this.getList(x).retrieve();
    }

    public LinkedListItr<E> getList(E x) {
        int hash = x.hashCode();
        int currentPos = (hash & Integer.MAX_VALUE) % this.theLists.length;
        return this.theLists[currentPos].find(x);
    }

    public void makeEmpty() {
        for (int i = 0; i < this.theLists.length; ++i) {
            this.theLists[i].makeEmpty();
        }
    }

    public static int hashString(String key, int tableSize) {
        int hashVal = 0;
        for (int i = 0; i < key.length(); ++i) {
            hashVal = 37 * hashVal + key.charAt(i);
        }
        if ((hashVal %= tableSize) < 0) {
            hashVal += tableSize;
        }
        return hashVal;
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!SeparateChainingHashTable.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public static void main(String[] args) {
        SeparateChainingHashTable<Integer> H = new SeparateChainingHashTable<Integer>();
        int NUMS = 4000;
        int GAP = 37;
        System.out.println("Checking... (no more output means success)");
        int i = 37;
        while (i != 0) {
            H.put(i);
            i = (i + 37) % 4000;
        }
        for (i = 1; i < 4000; i += 2) {
            H.remove(i);
        }
        for (i = 2; i < 4000; i += 2) {
            if (H.get(i) == i) continue;
            System.out.println("Find fails " + i);
        }
        for (i = 1; i < 4000; i += 2) {
            if (H.get(i) == null) continue;
            System.out.println("OOPS!!! " + i);
        }
    }
}

