/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.cafe4j.util.SinglyLinkedListNode;
import java.lang.reflect.Array;

public class SinglyLinkedList<E> {
    private int count = 0;
    private SinglyLinkedListNode<E> head = null;

    public void addToHead(E value) {
        this.head = new SinglyLinkedListNode<E>(value, this.head);
        ++this.count;
    }

    public void add(E value) {
        this.addToHead(value);
    }

    public E removeFromHead() {
        SinglyLinkedListNode<E> temp = this.head;
        if (this.head != null) {
            this.head = this.head.next();
            --this.count;
            return temp.getValue();
        }
        return null;
    }

    public E remove() {
        return this.removeFromHead();
    }

    public void addToTail(E value) {
        SinglyLinkedListNode<E> previous = null;
        for (SinglyLinkedListNode<E> temp = this.head; temp != null; temp = temp.next()) {
            previous = temp;
        }
        if (previous != null) {
            previous.setNext(new SinglyLinkedListNode<E>(value, null));
        } else {
            this.head = new SinglyLinkedListNode<E>(value, null);
        }
        ++this.count;
    }

    public E removeFromTail() {
        SinglyLinkedListNode temp = this.head;
        SinglyLinkedListNode previous = null;
        if (temp != null) {
            while (temp.next() != null) {
                previous = temp;
                temp = temp.next();
            }
            if (previous != null) {
                previous.setNext(null);
            } else {
                this.head = null;
            }
            --this.count;
            return temp.getValue();
        }
        return null;
    }

    public E peekHead() {
        return this.head != null ? (E)this.head.getValue() : null;
    }

    public E peekTail() {
        SinglyLinkedListNode<E> previous = null;
        for (SinglyLinkedListNode<E> temp = this.head; temp != null; temp = temp.next()) {
            previous = temp;
        }
        return previous != null ? (E)previous.getValue() : null;
    }

    public boolean contains(E value) {
        SinglyLinkedListNode<E> temp;
        for (temp = this.head; temp != null && !temp.getValue().equals(value); temp = temp.next()) {
        }
        return temp != null;
    }

    public E remove(E value) {
        SinglyLinkedListNode<E> temp;
        SinglyLinkedListNode<E> previous = null;
        for (temp = this.head; temp != null && !temp.getValue().equals(value); temp = temp.next()) {
            previous = temp;
        }
        if (temp != null) {
            if (previous != null) {
                previous.setNext(temp.next());
            } else {
                this.head = temp.next();
            }
            --this.count;
            return temp.getValue();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public void reverse() {
        if (this.head == null) {
            return;
        }
        SinglyLinkedListNode<E> currNode = this.head;
        SinglyLinkedListNode nextNode = this.head.next;
        this.head.next = null;
        while (nextNode != null) {
            SinglyLinkedListNode loopNode = nextNode.next;
            nextNode.next = currNode;
            currNode = nextNode;
            nextNode = loopNode;
        }
        this.head = currNode;
    }

    public void reverse(SinglyLinkedListNode<E> curr) {
        if (curr == null) {
            return;
        }
        if (curr.next == null) {
            this.head = curr;
            return;
        }
        this.reverse(curr.next);
        curr.next.next = curr;
        curr.next = null;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.head = null;
        this.count = 0;
    }

    public E[] toArray(E[] a) {
        if (a.length < this.count) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
        }
        int i = 0;
        for (SinglyLinkedListNode<E> e = this.head; e != null; e = e.next()) {
            a[i++] = e.getValue();
        }
        if (a.length > this.count) {
            a[this.count] = null;
        }
        return a;
    }

    public void transferList(SinglyLinkedList<E> list) {
        list.head = this.head;
        list.count = this.count;
        this.clear();
    }
}

