/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftReference<V>> hash = new HashMap<K, SoftReference<V>>();
    private final Map<SoftReference<V>, K> reverseLookup = new HashMap<SoftReference<V>, K>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public V get(Object key) {
        this.expungeStaleEntries();
        V result = null;
        SoftReference<V> soft_ref = this.hash.get(key);
        if (soft_ref != null && (result = (V)soft_ref.get()) == null) {
            this.hash.remove(key);
            this.reverseLookup.remove(soft_ref);
        }
        return result;
    }

    private void expungeStaleEntries() {
        Reference<V> sv;
        while ((sv = this.queue.poll()) != null) {
            this.hash.remove(this.reverseLookup.remove(sv));
        }
    }

    @Override
    public V put(K key, V value) {
        this.expungeStaleEntries();
        SoftReference<V> soft_ref = new SoftReference<V>(value, this.queue);
        this.reverseLookup.put((SoftReference<K>)soft_ref, (SoftReference<V>)key);
        SoftReference<V> result = this.hash.put(key, soft_ref);
        if (result == null) {
            return null;
        }
        this.reverseLookup.remove(result);
        return result.get();
    }

    @Override
    public V remove(Object key) {
        this.expungeStaleEntries();
        SoftReference<V> result = this.hash.remove(key);
        if (result == null) {
            return null;
        }
        return result.get();
    }

    @Override
    public void clear() {
        this.hash.clear();
        this.reverseLookup.clear();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.hash.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expungeStaleEntries();
        LinkedHashSet<Map.Entry<K, V>> result = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Map.Entry<K, SoftReference<V>> entry : this.hash.entrySet()) {
            final V value = entry.getValue().get();
            if (value == null) continue;
            result.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V v) {
                    entry.setValue(new SoftReference(v, SoftHashMap.this.queue));
                    return value;
                }
            });
        }
        return result;
    }
}

