/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.util;

import guilibshadow.cafe4j.util.SinglyLinkedListNode;
import java.lang.reflect.Array;

public class SortedSinglyLinkedList<E extends Comparable<? super E>> {
    private int count = 0;
    private SinglyLinkedListNode<E> head = null;

    public void add(E content) {
        if (this.head == null) {
            this.head = new SinglyLinkedListNode<E>(content);
        } else {
            SinglyLinkedListNode<E> curr;
            SinglyLinkedListNode<E> prev = null;
            for (curr = this.head; curr != null && content.compareTo(curr.getValue()) > 0; curr = curr.next()) {
                prev = curr;
            }
            if (prev != null) {
                prev.setNext(new SinglyLinkedListNode<E>(content, curr));
            } else {
                this.head = new SinglyLinkedListNode<E>(content, this.head);
            }
        }
        ++this.count;
    }

    public E removeFromHead() {
        SinglyLinkedListNode<E> temp = this.head;
        if (this.head != null) {
            this.head = this.head.next();
            --this.count;
            return (E)((Comparable)temp.getValue());
        }
        return null;
    }

    public E removeFromTail() {
        SinglyLinkedListNode temp = this.head;
        SinglyLinkedListNode previous = null;
        if (temp != null) {
            while (temp.next() != null) {
                previous = temp;
                temp = temp.next();
            }
            if (previous != null) {
                previous.setNext(null);
            } else {
                this.head = null;
            }
            --this.count;
            return (E)((Comparable)temp.getValue());
        }
        return null;
    }

    public boolean contains(E value) {
        SinglyLinkedListNode<E> temp;
        for (temp = this.head; temp != null && ((Comparable)temp.getValue()).compareTo(value) < 0; temp = temp.next()) {
        }
        return temp != null && ((Comparable)temp.getValue()).compareTo(value) == 0;
    }

    public E remove(E value) {
        SinglyLinkedListNode<E> temp;
        SinglyLinkedListNode<E> previous = null;
        for (temp = this.head; temp != null && ((Comparable)temp.getValue()).compareTo(value) < 0; temp = temp.next()) {
            previous = temp;
        }
        if (temp != null && ((Comparable)temp.getValue()).compareTo(value) == 0) {
            if (previous != null) {
                previous.setNext(temp.next());
            } else {
                this.head = temp.next();
            }
            --this.count;
            return (E)((Comparable)temp.getValue());
        }
        return null;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.head = null;
        this.count = 0;
    }

    public E[] toArray(E[] a) {
        if (a.length < this.count) {
            a = (Comparable[])Array.newInstance(a.getClass().getComponentType(), this.count);
        }
        int i = 0;
        for (SinglyLinkedListNode<E> e = this.head; e != null; e = e.next()) {
            a[i++] = (Comparable)e.getValue();
        }
        if (a.length > this.count) {
            a[this.count] = null;
        }
        return a;
    }

    public static void main(String[] args) {
        SortedSinglyLinkedList<Integer> t = new SortedSinglyLinkedList<Integer>();
        int NUMS = 100;
        int GAP = 37;
        int i = 37;
        while (i != 0) {
            t.add(i);
            i = (i + 37) % 100;
        }
        t.add(5);
        for (i = 1; i < 100; ++i) {
            while (t.contains(i)) {
                System.out.println(t.remove(i));
            }
        }
        if (t.isEmpty() && t.size() == 0) {
            System.out.println("List is empty now...");
        }
    }
}

