/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.jj2000.j2k.codestream.writer;

import guilibshadow.jj2000.j2k.codestream.writer.BitOutputBuffer;
import guilibshadow.jj2000.j2k.util.ArrayUtil;

public class TagTreeEncoder {
    protected int w;
    protected int h;
    protected int lvls;
    protected int[][] treeV;
    protected int[][] treeS;
    protected int[][] treeVbak;
    protected int[][] treeSbak;
    protected boolean saved;

    public TagTreeEncoder(int h, int w) {
        if (w < 0 || h < 0) {
            throw new IllegalArgumentException();
        }
        this.init(w, h);
        for (int k = this.treeV.length - 1; k >= 0; --k) {
            ArrayUtil.intArraySet(this.treeV[k], Integer.MAX_VALUE);
        }
    }

    public TagTreeEncoder(int h, int w, int[] val) {
        if (w < 0 || h < 0 || val.length < w * h) {
            throw new IllegalArgumentException();
        }
        this.init(w, h);
        for (int k = w * h - 1; k >= 0; --k) {
            this.treeV[0][k] = val[k];
        }
        this.recalcTreeV();
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    private void init(int w, int h) {
        this.w = w;
        this.h = h;
        if (w == 0 || h == 0) {
            this.lvls = 0;
        } else {
            this.lvls = 1;
            while (h != 1 || w != 1) {
                w = w + 1 >> 1;
                h = h + 1 >> 1;
                ++this.lvls;
            }
        }
        this.treeV = new int[this.lvls][];
        this.treeS = new int[this.lvls][];
        w = this.w;
        h = this.h;
        for (int i = 0; i < this.lvls; ++i) {
            this.treeV[i] = new int[h * w];
            this.treeS[i] = new int[h * w];
            w = w + 1 >> 1;
            h = h + 1 >> 1;
        }
    }

    private void recalcTreeV() {
        for (int k = 0; k < this.lvls - 1; ++k) {
            int bi;
            int n;
            int m;
            int lw = this.w + (1 << k) - 1 >> k;
            int lh = this.h + (1 << k) - 1 >> k;
            for (m = (lh >> 1 << 1) - 2; m >= 0; m -= 2) {
                for (n = (lw >> 1 << 1) - 2; n >= 0; n -= 2) {
                    bi = m * lw + n;
                    int tm1 = this.treeV[k][bi] < this.treeV[k][bi + 1] ? this.treeV[k][bi] : this.treeV[k][bi + 1];
                    int tm2 = this.treeV[k][bi + lw] < this.treeV[k][bi + lw + 1] ? this.treeV[k][bi + lw] : this.treeV[k][bi + lw + 1];
                    this.treeV[k + 1][(m >> 1) * (lw + 1 >> 1) + (n >> 1)] = tm1 < tm2 ? tm1 : tm2;
                }
                if (lw % 2 == 0) continue;
                n = lw >> 1 << 1;
                bi = m * lw + n;
                this.treeV[k + 1][(m >> 1) * (lw + 1 >> 1) + (n >> 1)] = this.treeV[k][bi] < this.treeV[k][bi + lw] ? this.treeV[k][bi] : this.treeV[k][bi + lw];
            }
            if (lh % 2 == 0) continue;
            m = lh >> 1 << 1;
            for (n = (lw >> 1 << 1) - 2; n >= 0; n -= 2) {
                bi = m * lw + n;
                this.treeV[k + 1][(m >> 1) * (lw + 1 >> 1) + (n >> 1)] = this.treeV[k][bi] < this.treeV[k][bi + 1] ? this.treeV[k][bi] : this.treeV[k][bi + 1];
            }
            if (lw % 2 == 0) continue;
            n = lw >> 1 << 1;
            this.treeV[k + 1][(m >> 1) * (lw + 1 >> 1) + (n >> 1)] = this.treeV[k][m * lw + n];
        }
    }

    public void setValue(int m, int n, int v) {
        int idx;
        if (this.lvls == 0 || n < 0 || n >= this.w || v < this.treeS[this.lvls - 1][0] || this.treeV[0][m * this.w + n] < this.treeS[this.lvls - 1][0]) {
            throw new IllegalArgumentException();
        }
        this.treeV[0][m * this.w + n] = v;
        for (int k = 1; k < this.lvls && v < this.treeV[k][idx = (m >> k) * (this.w + (1 << k) - 1 >> k) + (n >> k)]; ++k) {
            this.treeV[k][idx] = v;
        }
    }

    public void setValues(int[] val) {
        if (this.lvls == 0) {
            throw new IllegalArgumentException();
        }
        int maxt = this.treeS[this.lvls - 1][0];
        for (int i = this.w * this.h - 1; i >= 0; --i) {
            if ((this.treeV[0][i] < maxt || val[i] < maxt) && this.treeV[0][i] != val[i]) {
                throw new IllegalArgumentException();
            }
            this.treeV[0][i] = val[i];
        }
        this.recalcTreeV();
    }

    public void encode(int m, int n, int t, BitOutputBuffer out) {
        if (m >= this.h || n >= this.w || t < 0) {
            throw new IllegalArgumentException();
        }
        int k = this.lvls - 1;
        int tmin = this.treeS[k][0];
        while (true) {
            int idx;
            int ts;
            if ((ts = this.treeS[k][idx = (m >> k) * (this.w + (1 << k) - 1 >> k) + (n >> k)]) < tmin) {
                ts = tmin;
            }
            while (t > ts) {
                if (this.treeV[k][idx] > ts) {
                    out.writeBit(0);
                } else if (this.treeV[k][idx] == ts) {
                    out.writeBit(1);
                } else {
                    ts = t;
                    break;
                }
                ++ts;
            }
            this.treeS[k][idx] = ts;
            if (k <= 0) break;
            tmin = ts < this.treeV[k][idx] ? ts : this.treeV[k][idx];
            --k;
        }
    }

    public void save() {
        int k;
        if (this.treeVbak == null) {
            this.treeVbak = new int[this.lvls][];
            this.treeSbak = new int[this.lvls][];
            for (k = this.lvls - 1; k >= 0; --k) {
                this.treeVbak[k] = new int[this.treeV[k].length];
                this.treeSbak[k] = new int[this.treeV[k].length];
            }
        }
        for (k = this.treeV.length - 1; k >= 0; --k) {
            System.arraycopy(this.treeV[k], 0, this.treeVbak[k], 0, this.treeV[k].length);
            System.arraycopy(this.treeS[k], 0, this.treeSbak[k], 0, this.treeS[k].length);
        }
        this.saved = true;
    }

    public void restore() {
        if (!this.saved) {
            throw new IllegalArgumentException();
        }
        for (int k = this.lvls - 1; k >= 0; --k) {
            System.arraycopy(this.treeVbak[k], 0, this.treeV[k], 0, this.treeV[k].length);
            System.arraycopy(this.treeSbak[k], 0, this.treeS[k], 0, this.treeS[k].length);
        }
    }

    public void reset() {
        for (int k = this.lvls - 1; k >= 0; --k) {
            ArrayUtil.intArraySet(this.treeV[k], Integer.MAX_VALUE);
            ArrayUtil.intArraySet(this.treeS[k], 0);
        }
        this.saved = false;
    }

    public void reset(int[] val) {
        int k;
        for (k = this.w * this.h - 1; k >= 0; --k) {
            this.treeV[0][k] = val[k];
        }
        this.recalcTreeV();
        for (k = this.lvls - 1; k >= 0; --k) {
            ArrayUtil.intArraySet(this.treeS[k], 0);
        }
        this.saved = false;
    }
}

