/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.jj2000.j2k.entropy.decoder;

import guilibshadow.jj2000.j2k.entropy.decoder.ByteInputBuffer;
import guilibshadow.jj2000.j2k.util.ArrayUtil;

public class MQDecoder {
    static final int[] qe = new int[]{22017, 13313, 6145, 2753, 1313, 545, 22017, 21505, 18433, 14337, 12289, 9217, 7169, 5633, 22017, 21505, 20737, 18433, 14337, 13313, 12289, 10241, 9217, 8705, 7169, 6145, 5633, 5121, 4609, 4353, 2753, 2497, 2209, 1313, 1089, 673, 545, 321, 273, 133, 73, 37, 21, 9, 5, 1, 22017};
    static final int[] nMPS = new int[]{1, 2, 3, 4, 5, 38, 7, 8, 9, 10, 11, 12, 13, 29, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 45, 46};
    static final int[] nLPS = new int[]{1, 6, 9, 12, 29, 33, 6, 14, 14, 14, 17, 18, 20, 21, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 46};
    static final int[] switchLM = new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    ByteInputBuffer in;
    int[] mPS;
    int[] I;
    int c;
    int cT;
    int a;
    int b;
    boolean markerFound;
    final int[] initStates;

    public MQDecoder(ByteInputBuffer iStream, int nrOfContexts, int[] initStates) {
        this.in = iStream;
        this.I = new int[nrOfContexts];
        this.mPS = new int[nrOfContexts];
        this.initStates = initStates;
        this.init();
        this.resetCtxts();
    }

    public final boolean fastDecodeSymbols(int[] bits, int ctxt, int n) {
        int idx = this.I[ctxt];
        int q = qe[idx];
        if (q < 16384 && n <= (this.a - (this.c >>> 16) - 1) / q && n <= (this.a - 32768) / q + 1) {
            this.a -= n * q;
            if (this.a >= 32768) {
                bits[0] = this.mPS[ctxt];
                return true;
            }
            this.I[ctxt] = nMPS[idx];
            if (this.cT == 0) {
                this.byteIn();
            }
            this.a <<= 1;
            this.c <<= 1;
            --this.cT;
            bits[0] = this.mPS[ctxt];
            return true;
        }
        int la = this.a;
        for (int i = 0; i < n; ++i) {
            if (this.c >>> 16 < (la -= q)) {
                if (la >= 32768) {
                    bits[i] = this.mPS[ctxt];
                    continue;
                }
                if (la >= q) {
                    bits[i] = this.mPS[ctxt];
                    idx = nMPS[idx];
                    q = qe[idx];
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    la <<= 1;
                    this.c <<= 1;
                    --this.cT;
                    continue;
                }
                bits[i] = 1 - this.mPS[ctxt];
                if (switchLM[idx] == 1) {
                    this.mPS[ctxt] = 1 - this.mPS[ctxt];
                }
                idx = nLPS[idx];
                q = qe[idx];
                do {
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    this.c <<= 1;
                    --this.cT;
                } while ((la <<= 1) < 32768);
                continue;
            }
            this.c -= la << 16;
            if (la < q) {
                la = q;
                bits[i] = this.mPS[ctxt];
                idx = nMPS[idx];
                q = qe[idx];
                if (this.cT == 0) {
                    this.byteIn();
                }
                la <<= 1;
                this.c <<= 1;
                --this.cT;
                continue;
            }
            la = q;
            bits[i] = 1 - this.mPS[ctxt];
            if (switchLM[idx] == 1) {
                this.mPS[ctxt] = 1 - this.mPS[ctxt];
            }
            idx = nLPS[idx];
            q = qe[idx];
            do {
                if (this.cT == 0) {
                    this.byteIn();
                }
                this.c <<= 1;
                --this.cT;
            } while ((la <<= 1) < 32768);
        }
        this.a = la;
        this.I[ctxt] = idx;
        return false;
    }

    public final void decodeSymbols(int[] bits, int[] cX, int n) {
        for (int i = 0; i < n; ++i) {
            int la;
            int ctxt = cX[i];
            int index = this.I[ctxt];
            int q = qe[index];
            this.a -= q;
            if (this.c >>> 16 < this.a) {
                if (this.a >= 32768) {
                    bits[i] = this.mPS[ctxt];
                    continue;
                }
                la = this.a;
                if (la >= q) {
                    bits[i] = this.mPS[ctxt];
                    this.I[ctxt] = nMPS[index];
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    la <<= 1;
                    this.c <<= 1;
                    --this.cT;
                } else {
                    bits[i] = 1 - this.mPS[ctxt];
                    if (switchLM[index] == 1) {
                        this.mPS[ctxt] = 1 - this.mPS[ctxt];
                    }
                    this.I[ctxt] = nLPS[index];
                    do {
                        if (this.cT == 0) {
                            this.byteIn();
                        }
                        this.c <<= 1;
                        --this.cT;
                    } while ((la <<= 1) < 32768);
                }
                this.a = la;
                continue;
            }
            la = this.a;
            this.c -= la << 16;
            if (la < q) {
                la = q;
                bits[i] = this.mPS[ctxt];
                this.I[ctxt] = nMPS[index];
                if (this.cT == 0) {
                    this.byteIn();
                }
                la <<= 1;
                this.c <<= 1;
                --this.cT;
            } else {
                la = q;
                bits[i] = 1 - this.mPS[ctxt];
                if (switchLM[index] == 1) {
                    this.mPS[ctxt] = 1 - this.mPS[ctxt];
                }
                this.I[ctxt] = nLPS[index];
                do {
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    this.c <<= 1;
                    --this.cT;
                } while ((la <<= 1) < 32768);
            }
            this.a = la;
        }
    }

    public final int decodeSymbol(int context) {
        int decision;
        int index = this.I[context];
        int q = qe[index];
        this.a -= q;
        if (this.c >>> 16 < this.a) {
            if (this.a >= 32768) {
                decision = this.mPS[context];
            } else {
                int la = this.a;
                if (la >= q) {
                    decision = this.mPS[context];
                    this.I[context] = nMPS[index];
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    la <<= 1;
                    this.c <<= 1;
                    --this.cT;
                } else {
                    decision = 1 - this.mPS[context];
                    if (switchLM[index] == 1) {
                        this.mPS[context] = 1 - this.mPS[context];
                    }
                    this.I[context] = nLPS[index];
                    do {
                        if (this.cT == 0) {
                            this.byteIn();
                        }
                        this.c <<= 1;
                        --this.cT;
                    } while ((la <<= 1) < 32768);
                }
                this.a = la;
            }
        } else {
            int la = this.a;
            this.c -= la << 16;
            if (la < q) {
                la = q;
                decision = this.mPS[context];
                this.I[context] = nMPS[index];
                if (this.cT == 0) {
                    this.byteIn();
                }
                la <<= 1;
                this.c <<= 1;
                --this.cT;
            } else {
                la = q;
                decision = 1 - this.mPS[context];
                if (switchLM[index] == 1) {
                    this.mPS[context] = 1 - this.mPS[context];
                }
                this.I[context] = nLPS[index];
                do {
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    this.c <<= 1;
                    --this.cT;
                } while ((la <<= 1) < 32768);
            }
            this.a = la;
        }
        return decision;
    }

    public boolean checkPredTerm() {
        if (this.b != 255 && !this.markerFound) {
            return true;
        }
        if (this.cT != 0 && !this.markerFound) {
            return true;
        }
        if (this.cT == 1) {
            return false;
        }
        if (this.cT == 0) {
            if (!this.markerFound) {
                this.b = this.in.read() & 0xFF;
                if (this.b <= 143) {
                    return true;
                }
            }
            this.cT = 8;
        }
        int k = this.cT - 1;
        int q = 32768 >> k;
        this.a -= q;
        if (this.c >>> 16 < this.a) {
            return true;
        }
        this.c -= this.a << 16;
        this.a = q;
        do {
            if (this.cT == 0) {
                this.byteIn();
            }
            this.a <<= 1;
            this.c <<= 1;
            --this.cT;
        } while (this.a < 32768);
        return false;
    }

    private void byteIn() {
        if (!this.markerFound) {
            if (this.b == 255) {
                this.b = this.in.read() & 0xFF;
                if (this.b > 143) {
                    this.markerFound = true;
                    this.cT = 8;
                } else {
                    this.c += 65024 - (this.b << 9);
                    this.cT = 7;
                }
            } else {
                this.b = this.in.read() & 0xFF;
                this.c += 65280 - (this.b << 8);
                this.cT = 8;
            }
        } else {
            this.cT = 8;
        }
    }

    public final int getNumCtxts() {
        return this.I.length;
    }

    public final void resetCtxt(int c) {
        this.I[c] = this.initStates[c];
        this.mPS[c] = 0;
    }

    public final void resetCtxts() {
        System.arraycopy(this.initStates, 0, this.I, 0, this.I.length);
        ArrayUtil.intArraySet(this.mPS, 0);
    }

    public final void nextSegment(byte[] buf, int off, int len) {
        this.in.setByteArray(buf, off, len);
        this.init();
    }

    public ByteInputBuffer getByteInputBuffer() {
        return this.in;
    }

    private void init() {
        this.markerFound = false;
        this.b = this.in.read() & 0xFF;
        this.c = (this.b ^ 0xFF) << 16;
        this.byteIn();
        this.c <<= 7;
        this.cT -= 7;
        this.a = 32768;
    }
}

