/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.jj2000.j2k.roi;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import guilibshadow.jj2000.j2k.decoder.DecoderSpecs;
import guilibshadow.jj2000.j2k.image.DataBlk;
import guilibshadow.jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import guilibshadow.jj2000.j2k.roi.MaxShiftSpec;
import guilibshadow.jj2000.j2k.wavelet.synthesis.MultiResImgDataAdapter;
import guilibshadow.jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class ROIDeScaler
extends MultiResImgDataAdapter
implements CBlkQuantDataSrcDec {
    private MaxShiftSpec mss;
    public static final char OPT_PREFIX = 'R';
    private static final String[][] pinfo = new String[][]{{"Rno_roi", null, "This argument makes sure that the no ROI de-scaling is performed. Decompression is done like there is no ROI in the image", null}};
    private CBlkQuantDataSrcDec src;

    public ROIDeScaler(CBlkQuantDataSrcDec src, MaxShiftSpec mss) {
        super(src);
        this.src = src;
        this.mss = mss;
    }

    public SubbandSyn getSynSubbandTree(int t, int c) {
        return this.src.getSynSubbandTree(t, c);
    }

    public int getCbULX() {
        return this.src.getCbULX();
    }

    public int getCbULY() {
        return this.src.getCbULY();
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public DataBlk getCodeBlock(int c, int m, int n, SubbandSyn sb, DataBlk cblk) {
        return this.getInternCodeBlock(c, m, n, sb, cblk);
    }

    public DataBlk getInternCodeBlock(int c, int m, int n, SubbandSyn sb, DataBlk cblk) {
        cblk = this.src.getInternCodeBlock(c, m, n, sb, cblk);
        boolean noRoiInTile = false;
        if (this.mss == null || this.mss.getTileCompVal(this.getTileIdx(), c) == null) {
            noRoiInTile = true;
        }
        if (noRoiInTile || cblk == null) {
            return cblk;
        }
        int[] data = (int[])cblk.getData();
        int ulx = cblk.ulx;
        int uly = cblk.uly;
        int w = cblk.w;
        int h = cblk.h;
        int boost = (Integer)this.mss.getTileCompVal(this.getTileIdx(), c);
        int mask = (1 << sb.magbits) - 1 << 31 - sb.magbits;
        int mask2 = ~mask & Integer.MAX_VALUE;
        int wrap = cblk.scanw - w;
        int i = cblk.offset + cblk.scanw * (h - 1) + w - 1;
        for (int j = h; j > 0; --j) {
            int k = w;
            while (k > 0) {
                int tmp = data[i];
                if ((tmp & mask) == 0) {
                    data[i] = tmp & Integer.MIN_VALUE | tmp << boost;
                } else if ((tmp & mask2) != 0) {
                    data[i] = tmp & ~mask2 | 1 << 30 - sb.magbits;
                }
                --k;
                --i;
            }
            i -= wrap;
        }
        return cblk;
    }

    public static ROIDeScaler createInstance(CBlkQuantDataSrcDec src, J2KImageReadParamJava j2krparam, DecoderSpecs decSpec) {
        boolean noRoi = j2krparam.getNoROIDescaling();
        if (noRoi || decSpec.rois == null) {
            return new ROIDeScaler(src, null);
        }
        return new ROIDeScaler(src, decSpec.rois);
    }
}

