/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.jj2000.j2k.wavelet.synthesis;

import guilibshadow.jj2000.j2k.decoder.DecoderSpecs;
import guilibshadow.jj2000.j2k.wavelet.synthesis.InvWT;
import guilibshadow.jj2000.j2k.wavelet.synthesis.MultiResImgData;
import guilibshadow.jj2000.j2k.wavelet.synthesis.SubbandSyn;
import java.awt.Point;

public abstract class InvWTAdapter
implements InvWT {
    protected DecoderSpecs decSpec;
    protected MultiResImgData mressrc;
    protected int reslvl;
    protected int maxImgRes;

    protected InvWTAdapter(MultiResImgData src, DecoderSpecs decSpec) {
        this.mressrc = src;
        this.decSpec = decSpec;
        this.maxImgRes = decSpec.dls.getMin();
    }

    public void setImgResLevel(int rl) {
        if (rl < 0) {
            throw new IllegalArgumentException("Resolution level index cannot be negative.");
        }
        this.reslvl = rl;
    }

    public int getTileWidth() {
        int tIdx = this.getTileIdx();
        int rl = 10000;
        int nc = this.mressrc.getNumComps();
        for (int c = 0; c < nc; ++c) {
            int mrl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c).resLvl;
            if (mrl >= rl) continue;
            rl = mrl;
        }
        return this.mressrc.getTileWidth(rl);
    }

    public int getTileHeight() {
        int tIdx = this.getTileIdx();
        int rl = 10000;
        int nc = this.mressrc.getNumComps();
        for (int c = 0; c < nc; ++c) {
            int mrl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c).resLvl;
            if (mrl >= rl) continue;
            rl = mrl;
        }
        return this.mressrc.getTileHeight(rl);
    }

    public int getNomTileWidth() {
        return this.mressrc.getNomTileWidth();
    }

    public int getNomTileHeight() {
        return this.mressrc.getNomTileHeight();
    }

    public int getImgWidth() {
        return this.mressrc.getImgWidth(this.reslvl);
    }

    public int getImgHeight() {
        return this.mressrc.getImgHeight(this.reslvl);
    }

    public int getNumComps() {
        return this.mressrc.getNumComps();
    }

    public int getCompSubsX(int c) {
        return this.mressrc.getCompSubsX(c);
    }

    public int getCompSubsY(int c) {
        return this.mressrc.getCompSubsY(c);
    }

    public int getTileCompWidth(int t, int c) {
        int rl = this.mressrc.getSynSubbandTree((int)t, (int)c).resLvl;
        return this.mressrc.getTileCompWidth(t, c, rl);
    }

    public int getTileCompHeight(int t, int c) {
        int rl = this.mressrc.getSynSubbandTree((int)t, (int)c).resLvl;
        return this.mressrc.getTileCompHeight(t, c, rl);
    }

    public int getCompImgWidth(int c) {
        int rl = this.decSpec.dls.getMinInComp(c);
        return this.mressrc.getCompImgWidth(c, rl);
    }

    public int getCompImgHeight(int c) {
        int rl = this.decSpec.dls.getMinInComp(c);
        return this.mressrc.getCompImgHeight(c, rl);
    }

    public void setTile(int x, int y) {
        this.mressrc.setTile(x, y);
    }

    public void nextTile() {
        this.mressrc.nextTile();
    }

    public Point getTile(Point co) {
        return this.mressrc.getTile(co);
    }

    public int getTileIdx() {
        return this.mressrc.getTileIdx();
    }

    public int getCompULX(int c) {
        int tIdx = this.getTileIdx();
        int rl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c).resLvl;
        return this.mressrc.getResULX(c, rl);
    }

    public int getCompULY(int c) {
        int tIdx = this.getTileIdx();
        int rl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c).resLvl;
        return this.mressrc.getResULY(c, rl);
    }

    public int getImgULX() {
        return this.mressrc.getImgULX(this.reslvl);
    }

    public int getImgULY() {
        return this.mressrc.getImgULY(this.reslvl);
    }

    public int getTilePartULX() {
        return this.mressrc.getTilePartULX();
    }

    public int getTilePartULY() {
        return this.mressrc.getTilePartULY();
    }

    public Point getNumTiles(Point co) {
        return this.mressrc.getNumTiles(co);
    }

    public int getNumTiles() {
        return this.mressrc.getNumTiles();
    }

    public SubbandSyn getSynSubbandTree(int t, int c) {
        return this.mressrc.getSynSubbandTree(t, c);
    }
}

