/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.microsoft;

import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Vector;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.internal.Conversions;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.support.AbstractBox;
import org.mp4parser.support.RequiresParseDetailAspect;

public class XtraBox
extends AbstractBox {
    private static Logger LOG;
    public static final String TYPE = "Xtra";
    public static final int MP4_XTRA_BT_UNICODE = 8;
    public static final int MP4_XTRA_BT_INT64 = 19;
    public static final int MP4_XTRA_BT_FILETIME = 21;
    public static final int MP4_XTRA_BT_GUID = 72;
    private static final long FILETIME_EPOCH_DIFF = 11644473600000L;
    private static final long FILETIME_ONE_MILLISECOND = 10000L;
    Vector<XtraTag> tags = new Vector();
    ByteBuffer data;
    private boolean successfulParse = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        XtraBox.ajc$preClinit();
        LOG = LoggerFactory.getLogger(XtraBox.class);
    }

    public XtraBox() {
        super(TYPE);
    }

    public XtraBox(String type) {
        super(type);
    }

    private static long filetimeToMillis(long filetime) {
        return filetime / 10000L - 11644473600000L;
    }

    private static long millisToFiletime(long millis) {
        return (millis + 11644473600000L) * 10000L;
    }

    private static void writeAsciiString(ByteBuffer dest, String s) {
        try {
            dest.put(s.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    private static String readAsciiString(ByteBuffer content, int length) {
        byte[] s = new byte[length];
        content.get(s);
        try {
            return new String(s, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    private static String readUtf16String(ByteBuffer content, int length) {
        char[] s = new char[length / 2 - 1];
        int i = 0;
        while (i < length / 2 - 1) {
            s[i] = content.getChar();
            ++i;
        }
        content.getChar();
        return new String(s);
    }

    private static void writeUtf16String(ByteBuffer dest, String s) {
        char[] ar = s.toCharArray();
        int i = 0;
        while (i < ar.length) {
            dest.putChar(ar[i]);
            ++i;
        }
        dest.putChar('\u0000');
    }

    @Override
    protected long getContentSize() {
        if (this.successfulParse) {
            return this.detailSize();
        }
        return this.data.limit();
    }

    private int detailSize() {
        int size = 0;
        int i = 0;
        while (i < this.tags.size()) {
            size += this.tags.elementAt(i).getContentSize();
            ++i;
        }
        return size;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (!this.isParsed()) {
            this.parseDetails();
        }
        StringBuffer b = new StringBuffer();
        b.append("XtraBox[");
        for (XtraTag tag : this.tags) {
            for (XtraValue value : tag.values) {
                b.append(tag.tagName);
                b.append("=");
                b.append(value.toString());
                b.append(";");
            }
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        int boxSize = content.remaining();
        this.data = content.slice();
        this.successfulParse = false;
        try {
            try {
                this.tags.clear();
                while (content.remaining() > 0) {
                    XtraTag tag = new XtraTag();
                    tag.parse(content);
                    this.tags.addElement(tag);
                }
                int calcSize = this.detailSize();
                if (boxSize != calcSize) {
                    throw new RuntimeException("Improperly handled Xtra tag: Calculated sizes don't match ( " + boxSize + "/" + calcSize + ")");
                }
                this.successfulParse = true;
            }
            catch (Exception e) {
                this.successfulParse = false;
                LOG.error("Malformed Xtra Tag detected: {}", (Object)e.toString());
                ((Buffer)content).position(content.position() + content.remaining());
                content.order(ByteOrder.BIG_ENDIAN);
            }
        }
        finally {
            content.order(ByteOrder.BIG_ENDIAN);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        if (this.successfulParse) {
            int i = 0;
            while (i < this.tags.size()) {
                this.tags.elementAt(i).getContent(byteBuffer);
                ++i;
            }
        } else {
            ((Buffer)this.data).rewind();
            byteBuffer.put(this.data);
        }
    }

    public String[] getAllTagNames() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        String[] names = new String[this.tags.size()];
        int i = 0;
        while (i < this.tags.size()) {
            XtraTag tag = this.tags.elementAt(i);
            names[i] = tag.tagName;
            ++i;
        }
        return names;
    }

    public String getFirstStringValue(String name) {
        Object[] objs;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        Object[] objectArray = objs = this.getValues(name);
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof String) {
                return (String)obj;
            }
            ++n2;
        }
        return null;
    }

    public Date getFirstDateValue(String name) {
        Object[] objs;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        Object[] objectArray = objs = this.getValues(name);
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof Date) {
                return (Date)obj;
            }
            ++n2;
        }
        return null;
    }

    public Long getFirstLongValue(String name) {
        Object[] objs;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        Object[] objectArray = objs = this.getValues(name);
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof Long) {
                return (Long)obj;
            }
            ++n2;
        }
        return null;
    }

    public Object[] getValues(String name) {
        Object[] values;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        XtraTag tag = this.getTagByName(name);
        if (tag != null) {
            values = new Object[tag.values.size()];
            int i = 0;
            while (i < tag.values.size()) {
                values[i] = ((XtraValue)tag.values.elementAt(i)).getValueAsObject();
                ++i;
            }
        } else {
            values = new Object[]{};
        }
        return values;
    }

    public void removeTag(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        XtraTag tag = this.getTagByName(name);
        if (tag != null) {
            this.tags.remove(tag);
        }
    }

    public void setTagValues(String name, String[] values) {
        String string = name;
        String[] stringArray = values;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, this, this, string, stringArray);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.removeTag(name);
        XtraTag tag = new XtraTag(name);
        int i = 0;
        while (i < values.length) {
            tag.values.addElement(new XtraValue(values[i]));
            ++i;
        }
        this.tags.addElement(tag);
    }

    public void setTagValue(String name, String value) {
        String string = name;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this, string, string2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.setTagValues(name, new String[]{value});
    }

    public void setTagValue(String name, Date date) {
        String string = name;
        Date date2 = date;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, this, this, string, date2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.removeTag(name);
        XtraTag tag = new XtraTag(name);
        tag.values.addElement(new XtraValue(date));
        this.tags.addElement(tag);
    }

    public void setTagValue(String name, long value) {
        String string = name;
        long l = value;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, this, this, string, Conversions.longObject(l));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.removeTag(name);
        XtraTag tag = new XtraTag(name);
        tag.values.addElement(new XtraValue(value));
        this.tags.addElement(tag);
    }

    private XtraTag getTagByName(String name) {
        for (XtraTag tag : this.tags) {
            if (!tag.tagName.equals(name)) continue;
            return tag;
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("XtraBox.java", XtraBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.mp4parser.boxes.microsoft.XtraBox", "", "", "", "java.lang.String"), 136);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllTagNames", "org.mp4parser.boxes.microsoft.XtraBox", "", "", "", "[Ljava.lang.String;"), 197);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTagValue", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String:long", "name:value", "", "void"), 330);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstStringValue", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String", "name", "", "java.lang.String"), 212);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstDateValue", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String", "name", "", "java.util.Date"), 228);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstLongValue", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String", "name", "", "java.lang.Long"), 244);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValues", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String", "name", "", "[Ljava.lang.Object;"), 260);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTag", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String", "name", "", "void"), 279);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTagValues", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String:[Ljava.lang.String;", "name:values", "", "void"), 292);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTagValue", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String:java.lang.String", "name:value", "", "void"), 307);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTagValue", "org.mp4parser.boxes.microsoft.XtraBox", "java.lang.String:java.util.Date", "name:date", "", "void"), 317);
    }

    private static class XtraTag {
        private int inputSize;
        private String tagName;
        private Vector<XtraValue> values = new Vector();

        private XtraTag() {
        }

        private XtraTag(String name) {
            this();
            this.tagName = name;
        }

        private void parse(ByteBuffer content) {
            this.inputSize = content.getInt();
            int tagLength = content.getInt();
            this.tagName = XtraBox.readAsciiString(content, tagLength);
            int count = content.getInt();
            int i = 0;
            while (i < count) {
                XtraValue val = new XtraValue();
                val.parse(content);
                this.values.addElement(val);
                ++i;
            }
            if (this.inputSize != this.getContentSize()) {
                throw new RuntimeException("Improperly handled Xtra tag: Sizes don't match ( " + this.inputSize + "/" + this.getContentSize() + ") on " + this.tagName);
            }
        }

        private void getContent(ByteBuffer b) {
            b.putInt(this.getContentSize());
            b.putInt(this.tagName.length());
            XtraBox.writeAsciiString(b, this.tagName);
            b.putInt(this.values.size());
            int i = 0;
            while (i < this.values.size()) {
                this.values.elementAt(i).getContent(b);
                ++i;
            }
        }

        private int getContentSize() {
            int size = 12 + this.tagName.length();
            int i = 0;
            while (i < this.values.size()) {
                size += this.values.elementAt(i).getContentSize();
                ++i;
            }
            return size;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(this.tagName);
            b.append(" [");
            b.append(this.inputSize);
            b.append("/");
            b.append(this.values.size());
            b.append("]:\n");
            int i = 0;
            while (i < this.values.size()) {
                b.append("  ");
                b.append(this.values.elementAt(i).toString());
                b.append("\n");
                ++i;
            }
            return b.toString();
        }
    }

    private static class XtraValue {
        public int type;
        public String stringValue;
        public long longValue;
        public byte[] nonParsedValue;
        public Date fileTimeValue;

        private XtraValue() {
        }

        private XtraValue(String val) {
            this.type = 8;
            this.stringValue = val;
        }

        private XtraValue(long longVal) {
            this.type = 19;
            this.longValue = longVal;
        }

        private XtraValue(Date time) {
            this.type = 21;
            this.fileTimeValue = time;
        }

        private Object getValueAsObject() {
            switch (this.type) {
                case 8: {
                    return this.stringValue;
                }
                case 19: {
                    return new Long(this.longValue);
                }
                case 21: {
                    return this.fileTimeValue;
                }
            }
            return this.nonParsedValue;
        }

        private void parse(ByteBuffer content) {
            int length = content.getInt() - 6;
            this.type = content.getShort();
            content.order(ByteOrder.LITTLE_ENDIAN);
            switch (this.type) {
                case 8: {
                    this.stringValue = XtraBox.readUtf16String(content, length);
                    break;
                }
                case 19: {
                    this.longValue = content.getLong();
                    break;
                }
                case 21: {
                    this.fileTimeValue = new Date(XtraBox.filetimeToMillis(content.getLong()));
                    break;
                }
                default: {
                    this.nonParsedValue = new byte[length];
                    content.get(this.nonParsedValue);
                }
            }
            content.order(ByteOrder.BIG_ENDIAN);
        }

        private void getContent(ByteBuffer b) {
            try {
                int length = this.getContentSize();
                b.putInt(length);
                b.putShort((short)this.type);
                b.order(ByteOrder.LITTLE_ENDIAN);
                switch (this.type) {
                    case 8: {
                        XtraBox.writeUtf16String(b, this.stringValue);
                        break;
                    }
                    case 19: {
                        b.putLong(this.longValue);
                        break;
                    }
                    case 21: {
                        b.putLong(XtraBox.millisToFiletime(this.fileTimeValue.getTime()));
                        break;
                    }
                    default: {
                        b.put(this.nonParsedValue);
                        break;
                    }
                }
            }
            finally {
                b.order(ByteOrder.BIG_ENDIAN);
            }
        }

        private int getContentSize() {
            int size = 6;
            switch (this.type) {
                case 8: {
                    size += this.stringValue.length() * 2 + 2;
                    break;
                }
                case 19: 
                case 21: {
                    size += 8;
                    break;
                }
                default: {
                    size += this.nonParsedValue.length;
                }
            }
            return size;
        }

        public String toString() {
            switch (this.type) {
                case 8: {
                    return "[string]" + this.stringValue;
                }
                case 19: {
                    return "[long]" + this.longValue;
                }
                case 21: {
                    return "[filetime]" + this.fileTimeValue.toString();
                }
            }
            return "[GUID](nonParsed)";
        }
    }
}

