/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.support;

import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.mp4parser.Box;
import org.mp4parser.BoxParser;
import org.mp4parser.FullBox;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

public abstract class FullContainerBox
extends AbstractContainerBox
implements FullBox {
    private static Logger LOG = LoggerFactory.getLogger(FullContainerBox.class);
    private int version;
    private int flags;

    public FullContainerBox(String type) {
        super(type);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer versionAndFlags = ByteBuffer.allocate(4);
        dataSource.read(versionAndFlags);
        this.parseVersionAndFlags((ByteBuffer)((Buffer)versionAndFlags).rewind());
        super.parse(dataSource, header, contentSize, boxParser);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        super.getBox(writableByteChannel);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[childBoxes]";
    }

    protected final long parseVersionAndFlags(ByteBuffer content) {
        this.version = IsoTypeReader.readUInt8(content);
        this.flags = IsoTypeReader.readUInt24(content);
        return 4L;
    }

    protected final void writeVersionAndFlags(ByteBuffer bb) {
        IsoTypeWriter.writeUInt8(bb, this.version);
        IsoTypeWriter.writeUInt24(bb, this.flags);
    }

    @Override
    protected ByteBuffer getHeader() {
        ByteBuffer header;
        if (this.largeBox || this.getSize() >= 0x100000000L) {
            byte[] byArray = new byte[20];
            byArray[3] = 1;
            byArray[4] = this.type.getBytes()[0];
            byArray[5] = this.type.getBytes()[1];
            byArray[6] = this.type.getBytes()[2];
            byArray[7] = this.type.getBytes()[3];
            header = ByteBuffer.wrap(byArray);
            ((Buffer)header).position(8);
            IsoTypeWriter.writeUInt64(header, this.getSize());
            this.writeVersionAndFlags(header);
        } else {
            byte[] byArray = new byte[12];
            byArray[4] = this.type.getBytes()[0];
            byArray[5] = this.type.getBytes()[1];
            byArray[6] = this.type.getBytes()[2];
            byArray[7] = this.type.getBytes()[3];
            header = ByteBuffer.wrap(byArray);
            IsoTypeWriter.writeUInt32(header, this.getSize());
            ((Buffer)header).position(8);
            this.writeVersionAndFlags(header);
        }
        ((Buffer)header).rewind();
        return header;
    }
}

