/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves;

import com.mojang.brigadier.CommandDispatcher;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.werewolves.GeneralEventHandler;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModCommands;
import de.teamlapen.werewolves.core.ModLootTables;
import de.teamlapen.werewolves.core.RegistryManager;
import de.teamlapen.werewolves.data.BlockStateGenerator;
import de.teamlapen.werewolves.data.GlobalLootTableGenerator;
import de.teamlapen.werewolves.data.ItemModelGenerator;
import de.teamlapen.werewolves.data.LootTablesGenerator;
import de.teamlapen.werewolves.data.ModTagsProvider;
import de.teamlapen.werewolves.data.RecipeGenerator;
import de.teamlapen.werewolves.data.SkillNodeGenerator;
import de.teamlapen.werewolves.entities.ModEntityEventHandler;
import de.teamlapen.werewolves.entities.player.ModPlayerEventHandler;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.items.WerewolfRefinementItem;
import de.teamlapen.werewolves.modcompat.guide.WerewolvesGuideBook;
import de.teamlapen.werewolves.network.ModPacketDispatcher;
import de.teamlapen.werewolves.proxy.ClientProxy;
import de.teamlapen.werewolves.proxy.Proxy;
import de.teamlapen.werewolves.proxy.ServerProxy;
import de.teamlapen.werewolves.util.LordTitles;
import de.teamlapen.werewolves.util.Permissions;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WReference;
import de.teamlapen.werewolves.util.WUtils;
import de.teamlapen.werewolves.util.WerewolfVillageData;
import de.teamlapen.werewolves.world.WerewolfHeavenBiome;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="werewolves")
public class WerewolvesMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final AbstractPacketDispatcher dispatcher = new ModPacketDispatcher();
    public static final Proxy proxy = (Proxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final EntityClassification WEREWOLF_CREATURE_TYPE = EntityClassification.create((String)"werewolves_werewolf", (String)"werewolves_werewolf", (int)8, (boolean)false, (boolean)false, (int)128);
    private static final CreatureAttribute WEREWOLF_CREATURE_ATTRIBUTES = new CreatureAttribute();
    public static WerewolvesMod instance;
    public static boolean inDev;
    public final RegistryManager registryManager = new RegistryManager();
    private boolean setupAPI;

    public WerewolvesMod() {
        instance = this;
        this.checkDevEnv();
        WUtils.init();
        Optional opt = ModList.get().getModContainerById("vampirism");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::loadComplete);
        bus.addListener(this::processIMC);
        bus.addListener(this::enqueueIMC);
        bus.addListener(this::gatherData);
        bus.addListener(this::setUpClient);
        bus.addGenericListener(Block.class, this::blockRegister);
        bus.register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ModBiomes::onBiomeLoadingEventAdditions);
        MinecraftForge.EVENT_BUS.addListener(ModLootTables::onLootLoad);
        MinecraftForge.EVENT_BUS.addListener(WerewolfHeavenBiome::addFeatures);
        if (ModList.get().isLoaded("guideapi-vp")) {
            MinecraftForge.EVENT_BUS.addListener(WerewolvesGuideBook::onVampirismGuideBookCategoriesEvent);
        }
        WerewolvesConfig.registerConfigs();
        RegistryManager.setupRegistries(bus);
    }

    private void checkDevEnv() {
        String launchTarget = System.getenv().get("target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
    }

    private void setupAPI() {
        if (!this.setupAPI) {
            WReference.WEREWOLF_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.WEREWOLF_PLAYER_KEY, IWerewolfPlayer.class, () -> WerewolfPlayer.CAP).color(Color.orange).hostileTowardsNeutral().highestLevel(14).lordLevel(5).lordTitle(LordTitles::getWerewolfTitle).enableLordSkills().village(WerewolfVillageData::werewolfVillage).chatColor(TextFormatting.GOLD).name("text.werewolves.werewolf").namePlural("text.vampirism.werewolves").refinementItems(WerewolfRefinementItem::getRefinementItem).register();
            WReference.WEREWOLF_CREATURE_ATTRIBUTES = WEREWOLF_CREATURE_ATTRIBUTES;
            this.setupAPI = true;
        }
    }

    private void blockRegister(RegistryEvent.Register<Block> event) {
        this.setupAPI();
    }

    private void setup(FMLCommonSetupEvent event) {
        this.setupAPI();
        WerewolfPlayer.registerCapability();
        dispatcher.registerPackets();
        this.registryManager.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        MinecraftForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GeneralEventHandler());
        Permissions.init();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
    }

    private void processIMC(InterModProcessEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        HelperRegistry.registerPlayerEventReceivingCapability(WerewolfPlayer.CAP, WerewolfPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(WerewolfPlayer.CAP, (ResourceLocation)REFERENCE.WEREWOLF_PLAYER_KEY, WerewolfPlayer.class);
    }

    private void gatherData(GatherDataEvent event) {
        this.setupAPI();
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            ModTagsProvider.addProvider(generator, event.getExistingFileHelper());
            generator.func_200390_a((IDataProvider)new RecipeGenerator(generator));
            generator.func_200390_a((IDataProvider)new LootTablesGenerator(generator));
            generator.func_200390_a((IDataProvider)new GlobalLootTableGenerator(generator));
            generator.func_200390_a((IDataProvider)new SkillNodeGenerator(generator));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new ItemModelGenerator(generator, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new BlockStateGenerator(generator, event.getExistingFileHelper()));
        }
    }

    private void setUpClient(FMLClientSetupEvent event) {
        this.registryManager.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        ModCommands.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    static {
        inDev = false;
    }
}

