/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import de.teamlapen.werewolves.blocks.entity.StoneAltarTileEntity;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.util.WUtils;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

@ParametersAreNonnullByDefault
public class StoneAltarBlock
extends ContainerBlock
implements IWaterLoggable {
    protected static final VoxelShape SHAPE = StoneAltarBlock.makeShape();
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty SOUL_FIRE = WUtils.SOUL_FIRE;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;
    public static final String REG_NAME = "stone_altar";

    public StoneAltarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_235838_a_(state -> (Boolean)state.func_177229_b((Property)LIT) != false ? 14 : 0).func_235861_h_().harvestLevel(1).harvestTool(ToolType.PICKAXE));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
        VoxelShape b = Block.func_208617_a((double)1.0, (double)7.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        return VoxelShapes.func_197872_a((VoxelShape)a, (VoxelShape)b);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropItems(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT);
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, FluidState fluid) {
        if (super.func_204509_a(world, pos, state, fluid)) {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
                if (world.func_201670_d()) {
                    for (int i = 0; i < 20; ++i) {
                        CampfireBlock.func_220098_a((World)((World)world), (BlockPos)pos.func_177981_b(1), (boolean)false, (boolean)true);
                    }
                } else {
                    ((StoneAltarTileEntity)world.func_175625_s(pos)).aboardRitual();
                }
            }
            return true;
        }
        return false;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState state2, boolean p_220082_5_) {
        super.func_220082_b(state, world, pos, state2, p_220082_5_);
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && state2.func_177230_c() == this && !((Boolean)state2.func_177229_b((Property)LIT)).booleanValue()) {
            ((StoneAltarTileEntity)world.func_175625_s(pos)).startRitual(state);
        }
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        StoneAltarTileEntity te = (StoneAltarTileEntity)worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && te != null) {
            StoneAltarTileEntity.Result result = te.canActivate(player);
            if (!((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                switch (result) {
                    case OTHER_FACTION: {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.wrong_faction"), true);
                        return ActionResultType.CONSUME;
                    }
                    case IS_RUNNING: {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_still_running"), true);
                        return ActionResultType.CONSUME;
                    }
                }
                switch (result) {
                    case NIGHT_ONLY: {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_night_only"), true);
                        return ActionResultType.CONSUME;
                    }
                    case WRONG_LEVEL: {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_wrong_level"), true);
                        return ActionResultType.CONSUME;
                    }
                    case STRUCTURE_LESS: {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_structures_missing"), true);
                        return ActionResultType.CONSUME;
                    }
                    case STRUCTURE_LIT: {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_less_lit_structures"), true);
                        return ActionResultType.CONSUME;
                    }
                    case TO_LESS_BLOOD: {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_to_less_prey"), true);
                        return ActionResultType.CONSUME;
                    }
                    case INV_MISSING: {
                        Map<Item, Integer> missing = te.getMissingItems();
                        TranslationTextComponent s = new TranslationTextComponent("text.werewolves.stone_altar.ritual_missing_items");
                        missing.forEach((arg_0, arg_1) -> StoneAltarBlock.lambda$use$2((IFormattableTextComponent)s, arg_0, arg_1));
                        player.func_146105_b((ITextComponent)s, true);
                        player.func_213829_a((INamedContainerProvider)te);
                        break;
                    }
                    case OK: {
                        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.can_not_burn"), true);
                            player.func_213829_a((INamedContainerProvider)te);
                            return ActionResultType.CONSUME;
                        }
                        te.setPlayer(player);
                        if (heldItem.func_77973_b() == Items.field_221657_bQ || heldItem.func_77973_b() == Items.field_234737_dp_) {
                            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(heldItem.func_77973_b() == Items.field_234737_dp_)), 5);
                            return ActionResultType.CONSUME;
                        }
                        if (heldItem.func_190926_b()) {
                            player.func_213829_a((INamedContainerProvider)te);
                            return ActionResultType.CONSUME;
                        }
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.empty_hand"), true);
                        return ActionResultType.PASS;
                    }
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 2;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return ((TileEntityType)ModTiles.STONE_ALTAR.get()).func_200968_a();
    }

    private void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack item = inventory.func_70301_a(i);
                if (item.func_190926_b()) continue;
                float rx = rand.nextFloat() * 0.8f + 0.1f;
                float ry = rand.nextFloat() * 0.8f + 0.1f;
                float rz = rand.nextFloat() * 0.8f + 0.1f;
                ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), item.func_77946_l());
                if (item.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
                }
                float factor = 0.05f;
                entityItem.func_213293_j(rand.nextGaussian() * (double)factor, rand.nextGaussian() * (double)factor + (double)0.2f, rand.nextGaussian() * (double)factor);
                world.func_217376_c((Entity)entityItem);
                inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT}).func_206894_a(new Property[]{WATERLOGGED}).func_206894_a(new Property[]{SOUL_FIRE}).func_206894_a(new Property[]{HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f());
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            Vector3f offset = this.getTorchOffset(stateIn);
            worldIn.func_195594_a((IParticleData)((Boolean)stateIn.func_177229_b((Property)SOUL_FIRE) != false ? ParticleTypes.field_239811_B_ : ParticleTypes.field_197631_x), (double)((float)pos.func_177958_n() + offset.func_195899_a()), (double)((float)pos.func_177956_o() + offset.func_195900_b()), (double)((float)pos.func_177952_p() + offset.func_195902_c()), 0.0, 0.0, 0.0);
        }
    }

    private Vector3f getTorchOffset(BlockState stateIn) {
        Vector3f vec = new Vector3f(0.5f, 0.9625f, 0.5f);
        switch ((Direction)stateIn.func_177229_b((Property)HORIZONTAL_FACING)) {
            case EAST: {
                vec.func_229189_a_(new Vector3f(0.28125f, 0.0f, 0.28125f));
                break;
            }
            case SOUTH: {
                vec.func_229189_a_(new Vector3f(-0.28125f, 0.0f, 0.28125f));
                break;
            }
            case WEST: {
                vec.func_229189_a_(new Vector3f(-0.28125f, 0.0f, -0.28125f));
                break;
            }
            default: {
                vec.func_229189_a_(new Vector3f(0.28125f, 0.0f, -0.28125f));
            }
        }
        return vec;
    }

    private static /* synthetic */ void lambda$use$2(IFormattableTextComponent s, Item item, Integer integer) {
        s.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(item.func_77658_a()).func_240700_a_(style -> style.func_240712_a_(TextFormatting.AQUA).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230551_b_, (Object)new HoverEvent.ItemHover(new ItemStack((IItemProvider)item, integer.intValue())))))).func_240702_b_(" " + integer);
    }
}

