/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import de.teamlapen.werewolves.util.WUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class StoneAltarFireBowlBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final String REG_NAME = "stone_altar_fire_bowl";
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty SOUL_FIRE = WUtils.SOUL_FIRE;
    protected static final VoxelShape SHAPE = StoneAltarFireBowlBlock.makeShape();

    public StoneAltarFireBowlBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_235838_a_(state -> (Boolean)state.func_177229_b((Property)LIT) != false ? 14 : 0).func_235861_h_().harvestLevel(1).harvestTool(ToolType.PICKAXE));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    protected static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
        VoxelShape b = Block.func_208617_a((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
        VoxelShape c = Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        return VoxelShapes.func_216384_a((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c});
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand handIn, @Nonnull BlockRayTraceResult p_225533_6_) {
        ItemStack stack;
        if (!(((Boolean)state.func_177229_b((Property)LIT)).booleanValue() || (stack = player.func_184586_b(handIn)).func_77973_b() != Items.field_221657_bQ && stack.func_77973_b() != Items.field_234737_dp_ || ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue())) {
            worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(stack.func_77973_b() == Items.field_234737_dp_)));
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT}).func_206894_a(new Property[]{WATERLOGGED}).func_206894_a(new Property[]{SOUL_FIRE}).func_206894_a(new Property[]{field_185512_D});
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public ToolType getHarvestTool(@Nonnull BlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(@Nonnull BlockState state) {
        return 2;
    }

    public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        return super.isBurning(state, world, pos);
    }

    public boolean func_204509_a(@Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluidState fluid) {
        if (super.func_204509_a(world, pos, state, fluid)) {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
                if (world.func_201670_d()) {
                    for (int i = 0; i < 20; ++i) {
                        CampfireBlock.func_220098_a((World)((World)world), (BlockPos)pos.func_177981_b(1), (boolean)false, (boolean)true);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() + 0.7;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f());
    }
}

