/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks.entity;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.tile.InventoryTileEntity;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.blocks.StoneAltarBlock;
import de.teamlapen.werewolves.blocks.StoneAltarFireBowlBlock;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfLevelConf;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.inventory.container.StoneAltarContainer;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoneAltarTileEntity
extends InventoryTileEntity
implements ITickableTileEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ITextComponent NAME = new TranslationTextComponent("container.werewolves.stone_altar");
    private int targetLevel;
    private Phase phase = Phase.NOT_RUNNING;
    private PlayerEntity player;
    private UUID playerUuid;
    private int ticks;
    private final LazyOptional<IItemHandler> itemHandlerOptional = LazyOptional.of(() -> ((StoneAltarTileEntity)this).createWrapper());
    private List<BlockPos> fire_bowls;

    public StoneAltarTileEntity() {
        super((TileEntityType)ModTiles.STONE_ALTAR.get(), 2, StoneAltarContainer.SELECTOR_INFOS);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state;
            if (this.playerUuid != null) {
                if (!this.loadRitual(this.playerUuid)) {
                    return;
                }
                this.playerUuid = null;
                this.func_70296_d();
                state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
            state = this.field_145850_b.func_180495_p(this.field_174879_c);
            switch (this.phase) {
                case STARTING: {
                    if (this.ticks != 0) break;
                    this.phase = Phase.FOG;
                    this.ticks = 300;
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
                    break;
                }
                case FOG: {
                    if (this.ticks == 0) {
                        this.phase = Phase.ENDING;
                        this.ticks = 90;
                        this.player.func_195064_c(new EffectInstance(Effects.field_76440_q, 120, 3, false, false));
                        this.func_70296_d();
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)StoneAltarBlock.LIT, (Comparable)Boolean.valueOf(false)));
                        break;
                    }
                    if (this.ticks % 10 != 0) break;
                    ModParticles.spawnParticlesServer((World)this.field_145850_b, (IParticleData)ParticleTypes.field_197596_G, (double)((double)this.field_174879_c.func_177958_n() + Math.random()), (double)(this.field_174879_c.func_177956_o() + 1), (double)((double)this.field_174879_c.func_177952_p() + Math.random()), (int)30, (double)0.6, (double)0.6, (double)0.6, (double)0.0);
                    if (this.fire_bowls == null) break;
                    for (BlockPos fire_bowl : this.fire_bowls) {
                        ModParticles.spawnParticlesServer((World)this.field_145850_b, (IParticleData)ParticleTypes.field_197596_G, (double)((double)fire_bowl.func_177958_n() + Math.random()), (double)(fire_bowl.func_177956_o() + 1), (double)((double)fire_bowl.func_177952_p() + Math.random()), (int)30, (double)0.6, (double)0.6, (double)0.6, (double)0.0);
                    }
                    break;
                }
                case ENDING: {
                    if (this.ticks != 0) break;
                    this.phase = Phase.NOT_RUNNING;
                    this.endRitual();
                    this.cleanup();
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
                    break;
                }
                case NOT_RUNNING: {
                    return;
                }
            }
            --this.ticks;
        }
    }

    public void aboardRitual() {
        this.phase = Phase.NOT_RUNNING;
        this.ticks = 0;
        this.cleanup();
    }

    public boolean loadRitual(UUID playerUuid) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.func_217369_A().size() == 0) {
            return false;
        }
        this.player = this.field_145850_b.func_217371_b(playerUuid);
        if (this.player == null || !this.player.func_70089_S()) {
            this.phase = Phase.NOT_RUNNING;
            this.ticks = 0;
            LOGGER.warn("Failed to find player {}", (Object)playerUuid);
            return false;
        }
        this.targetLevel = WerewolfPlayer.get(this.player).getLevel() + 1;
        return true;
    }

    public void startRitual(BlockState state) {
        if (this.player == null) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)StoneAltarBlock.LIT, (Comparable)Boolean.valueOf(false)), 11);
            return;
        }
        if (this.phase == Phase.NOT_RUNNING && ((Boolean)state.func_177229_b((Property)StoneAltarBlock.LIT)).booleanValue()) {
            this.phase = Phase.STARTING;
            this.ticks = 40;
            this.consumeItems();
            this.func_70296_d();
        }
    }

    public void setPlayer(PlayerEntity player) {
        this.player = player;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void cleanup() {
        this.targetLevel = 0;
        this.player = null;
    }

    public void endRitual() {
        WerewolfPlayer.getOpt(this.player).ifPresent(werewolf -> {
            werewolf.getLevelHandler().reset();
            werewolf.syncLevelHandler();
        });
        FactionPlayerHandler handler = FactionPlayerHandler.get((PlayerEntity)this.player);
        int lvl = handler.getCurrentLevel() + 1;
        handler.setFactionLevel(WReference.WEREWOLF_FACTION, lvl);
    }

    public void consumeItems() {
        WerewolfLevelConf.StoneAltarRequirement requirement = (WerewolfLevelConf.StoneAltarRequirement)WerewolfLevelConf.getInstance().getRequirement(FactionPlayerHandler.get((PlayerEntity)this.player).getCurrentLevel() + 1);
        this.func_70301_a(0).func_190918_g(requirement.liverAmount);
        this.func_70301_a(1).func_190918_g(requirement.bonesAmount);
    }

    public Phase getCurrentPhase() {
        return this.phase;
    }

    public Result canActivate(PlayerEntity player) {
        if (this.phase != Phase.NOT_RUNNING) {
            return Result.IS_RUNNING;
        }
        if (!Helper.isWerewolf(player)) {
            return Result.OTHER_FACTION;
        }
        this.targetLevel = WerewolfPlayer.get(player).getLevel() + 1;
        if (!this.checkLevel(this.targetLevel)) {
            return Result.WRONG_LEVEL;
        }
        Result r = this.checkStructure();
        if (r != null) {
            return r;
        }
        if (player.func_130014_f_().func_72935_r()) {
            return Result.NIGHT_ONLY;
        }
        if (!this.checkItemRequirements(player)) {
            return Result.INV_MISSING;
        }
        if (!WerewolfPlayer.getOpt(player).map(w -> w.getLevelHandler().canLevelUp()).orElse(false).booleanValue() && !VampirismMod.inDev) {
            return Result.TO_LESS_BLOOD;
        }
        return Result.OK;
    }

    private Result checkStructure() {
        ArrayList<BlockPos> i = new ArrayList<BlockPos>();
        ArrayList<BlockPos> h = new ArrayList<BlockPos>();
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c).func_186662_g(3.0);
        for (double x = aabb.field_72340_a; x <= aabb.field_72336_d; x += 1.0) {
            for (double y = aabb.field_72338_b; y <= aabb.field_72337_e; y += 1.0) {
                for (double z = aabb.field_72339_c; z <= aabb.field_72334_f; z += 1.0) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.field_145850_b.func_180495_p(pos);
                    if (state.func_177230_c() != ModBlocks.STONE_ALTAR_FIRE_BOWL.get()) continue;
                    i.add(pos);
                    if (!((Boolean)state.func_177229_b((Property)StoneAltarFireBowlBlock.LIT)).booleanValue()) continue;
                    h.add(pos);
                }
            }
        }
        if (h.size() >= 4) {
            this.fire_bowls = h;
            return null;
        }
        if (i.size() >= 4) {
            return Result.STRUCTURE_LIT;
        }
        return Result.STRUCTURE_LESS;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemHandlerOptional.cast() : super.getCapability(cap, side);
    }

    private boolean checkLevel(int targetLevel) {
        return targetLevel >= 2 && targetLevel <= 14;
    }

    private boolean checkItemRequirements(PlayerEntity player) {
        WerewolfLevelConf.StoneAltarRequirement req = (WerewolfLevelConf.StoneAltarRequirement)WerewolfLevelConf.getInstance().getRequirement(this.targetLevel);
        ItemStack missing = InventoryHelper.checkItems((IInventory)this, (Item[])new Item[]{(Item)ModItems.LIVER.get(), (Item)ModItems.CRACKED_BONE.get()}, (int[])new int[]{req.liverAmount, req.bonesAmount});
        return missing.func_190926_b();
    }

    public Map<Item, Integer> getMissingItems() {
        WerewolfLevelConf.StoneAltarRequirement req = (WerewolfLevelConf.StoneAltarRequirement)WerewolfLevelConf.getInstance().getRequirement(this.targetLevel);
        return Helper.getMissingItems((IInventory)this, new Item[]{(Item)ModItems.LIVER.get(), (Item)ModItems.CRACKED_BONE.get()}, new int[]{req.liverAmount, req.bonesAmount});
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        return NAME;
    }

    @Nonnull
    protected Container func_213906_a(int id, @Nonnull PlayerInventory playerInventory) {
        return new StoneAltarContainer(id, playerInventory, (IInventory)this, this.field_145850_b == null ? IWorldPosCallable.field_221489_a : IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 12, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        if (tagCompound.func_186855_b("player")) {
            UUID playerUuid = tagCompound.func_186857_a("player");
            if (!this.loadRitual(playerUuid)) {
                this.playerUuid = playerUuid;
            }
            this.ticks = tagCompound.func_74762_e("ticks");
            this.phase = Phase.valueOf(tagCompound.func_74779_i("phase"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.player != null) {
            compound.func_186854_a("player", this.player.func_110124_au());
        }
        compound.func_74768_a("ticks", this.ticks);
        compound.func_74778_a("phase", this.phase.name());
        return super.func_189515_b(compound);
    }

    public static enum Phase {
        NOT_RUNNING,
        STARTING,
        FOG,
        ENDING;

    }

    public static enum Result {
        IS_RUNNING,
        OK,
        WRONG_LEVEL,
        NIGHT_ONLY,
        INV_MISSING,
        OTHER_FACTION,
        STRUCTURE_LESS,
        STRUCTURE_LIT,
        TO_LESS_BLOOD;

    }
}

