/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.client.gui.VampirismScreen;
import de.teamlapen.werewolves.client.core.ModEntityRenderer;
import de.teamlapen.werewolves.client.gui.ExpBar;
import de.teamlapen.werewolves.client.gui.StoneAltarScreen;
import de.teamlapen.werewolves.client.gui.WerewolfPlayerAppearanceScreen;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.mixin.client.ScreenAccessor;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private int zoomTime = 0;
    private double zoomAmount = 0.0;
    private double zoomModifier = 0.0;

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.getPlayer();
        if (this.shouldRenderWerewolfForm(player)) {
            event.setCanceled(ModEntityRenderer.render.render(WerewolfPlayer.get((PlayerEntity)player), MathHelper.func_219799_g((float)event.getPartialRenderTick(), (float)player.field_70126_B, (float)player.field_70177_z), event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight()));
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.getPlayer();
        if (this.shouldRenderWerewolfForm(player)) {
            ModEntityRenderer.render.renderPost((PlayerModel<AbstractClientPlayerEntity>)((PlayerModel)event.getRenderer().func_217764_d()), WerewolfPlayer.get((PlayerEntity)player), MathHelper.func_219799_g((float)event.getPartialRenderTick(), (float)player.field_70126_B, (float)player.field_70177_z), event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight());
        }
    }

    private boolean shouldRenderWerewolfForm(AbstractClientPlayerEntity player) {
        return Helper.isWerewolf((PlayerEntity)player) && (WerewolfPlayer.getOpt((PlayerEntity)player).map(w -> w.getForm().isTransformed()).orElse(false) != false || Minecraft.func_71410_x().field_71462_r instanceof WerewolfPlayerAppearanceScreen && ((WerewolfPlayerAppearanceScreen)Minecraft.func_71410_x().field_71462_r).isRenderForm());
    }

    @SubscribeEvent
    public void onFOVModifier(EntityViewRenderEvent.FOVModifier event) {
        if (this.zoomTime > 0) {
            event.setFOV(event.getFOV() - this.zoomModifier);
            this.zoomModifier -= this.zoomAmount;
            --this.zoomTime;
        }
    }

    @SubscribeEvent
    public void onGuiInitPost(GuiScreenEvent.InitGuiEvent.Post event) {
        boolean vampirismScreen = event.getGui() instanceof VampirismScreen;
        boolean stoneAltar = event.getGui() instanceof StoneAltarScreen;
        if ((vampirismScreen || stoneAltar) && Helper.isWerewolf((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            if (vampirismScreen) {
                ResourceLocation icon = new ResourceLocation("werewolves", "textures/gui/appearance_button.png");
                ((ScreenAccessor)event.getGui()).invokeAddButton_werewolves(new ImageButton(((VampirismScreen)event.getGui()).getGuiLeft() + 47, ((VampirismScreen)event.getGui()).getGuiTop() + 90, 20, 20, 0, 0, 20, icon, 20, 40, context -> Minecraft.func_71410_x().func_147108_a((Screen)new WerewolfPlayerAppearanceScreen(event.getGui())), (button1, matrixStack, mouseX, mouseY) -> event.getGui().func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.vampirism_menu.appearance_menu"), mouseX, mouseY), StringTextComponent.field_240750_d_));
            }
            WerewolfPlayer.getOpt((PlayerEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(werewolf -> {
                if (werewolf.getMaxLevel() == werewolf.getLevel()) {
                    return;
                }
                ContainerScreen screen = (ContainerScreen)event.getGui();
                ((ScreenAccessor)event.getGui()).invokeAddButton_werewolves(new ExpBar(screen.getGuiLeft() - 14, screen.getGuiTop(), (Screen)screen));
            });
        }
    }

    @SubscribeEvent
    public void onRenderNamePlate(RenderNameplateEvent event) {
        WerewolfPlayer werewolf;
        IActionHandler<IWerewolfPlayer> d;
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity()) && (d = (werewolf = WerewolfPlayer.get((PlayerEntity)event.getEntity())).getActionHandler()).isActionActive((ILastingAction)ModActions.HIDE_NAME.get()) && FormHelper.isFormActionActive(werewolf)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public void onZoomPressed() {
        this.zoomTime = 20;
        this.zoomAmount = Minecraft.func_71410_x().field_71474_y.field_74334_X / 4.0 / (double)this.zoomTime;
        this.zoomModifier = Minecraft.func_71410_x().field_71474_y.field_74334_X - Minecraft.func_71410_x().field_71474_y.field_74334_X / 4.0;
    }

    private static boolean shouldShowInTooltip(int p_242394_0_, ItemStack.TooltipDisplayFlags p_242394_1_) {
        return (p_242394_0_ & p_242394_1_.func_242397_a()) == 0;
    }

    private int getHideFlags(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("HideFlags", 99) ? stack.func_77978_p().func_74762_e("HideFlags") : 0;
    }
}

