/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderHandler
implements ISelectiveResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ENTITY_NEAR_SQ_DISTANCE = 100;
    @Nonnull
    private final Minecraft mc;
    private final int VISION_FADE_TICKS = 30;
    private OutlineLayerBuffer visionBuffer;
    private int ticks;
    private int lastTicks;
    @Nullable
    private ShaderGroup blurShader;
    private int displayHeight;
    private int displayWidth;
    private boolean isInsideVisionRendering = false;
    private Shader blit0;

    public RenderHandler(@Nonnull Minecraft mc) {
        this.mc = mc;
    }

    @Nullable
    public IResourceType getResourceType() {
        return VanillaResourceType.SHADERS;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71441_e == null || this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.lastTicks = this.ticks;
        WerewolfPlayer werewolf = WerewolfPlayer.get((PlayerEntity)this.mc.field_71439_g);
        if (werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.SENSE.get())) {
            if (this.ticks < 30) {
                ++this.ticks;
            }
        } else if (this.ticks > 0) {
            this.ticks -= 2;
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity;
        double dist;
        if (!this.isInsideVisionRendering && this.shouldRenderVision() && !((dist = this.mc.field_71439_g.func_70068_e((Entity)(entity = event.getEntity()))) > (double)((Integer)VampirismConfig.BALANCE.vsBloodVisionDistanceSq.get()).intValue()) && !entity.func_70090_H()) {
            int color = 0xA0A0A0;
            if (entity instanceof IFactionEntity) {
                color = ((IFactionEntity)entity).getFaction().getColor().getRGB();
            } else if (!entity.func_70662_br()) {
                color = 0xFF0000;
            }
            EntityRendererManager renderManager = this.mc.func_175598_ae();
            if (this.visionBuffer == null) {
                this.visionBuffer = new OutlineLayerBuffer(this.mc.func_228019_au_().func_228487_b_());
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int alpha = (int)((dist > 100.0 ? 50.0 : dist / 100.0 * 50.0) * (double)this.getVisionProgress(event.getPartialRenderTick()));
            this.visionBuffer.func_228472_a_(r, g, b, alpha);
            float f = MathHelper.func_219799_g((float)event.getPartialRenderTick(), (float)entity.field_70126_B, (float)entity.field_70177_z);
            this.isInsideVisionRendering = true;
            EntityRenderer entityRenderer = renderManager.func_78713_a((Entity)entity);
            entityRenderer.func_225623_a_((Entity)entity, f, event.getPartialRenderTick(), event.getMatrixStack(), (IRenderTypeBuffer)this.visionBuffer, renderManager.func_229085_a_((Entity)entity, event.getPartialRenderTick()));
            this.mc.func_147110_a().func_147610_a(false);
            this.isInsideVisionRendering = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.ticks = 0;
    }

    private float getVisionProgress(float partialTicks) {
        return ((float)this.ticks + (float)(this.ticks - this.lastTicks) * partialTicks) / 30.0f;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.mc.field_71441_e == null) {
            return;
        }
        float partialTicks = this.mc.func_184121_ak();
        if (this.displayHeight != this.mc.func_228018_at_().func_198091_l() || this.displayWidth != this.mc.func_228018_at_().func_198109_k()) {
            this.displayHeight = this.mc.func_228018_at_().func_198091_l();
            this.displayWidth = this.mc.func_228018_at_().func_198109_k();
            this.updateFramebufferSize(this.displayWidth, this.displayHeight);
        }
        if (this.shouldRenderVision()) {
            this.adjustVisionShaders(this.getVisionProgress(partialTicks));
            this.blurShader.func_148018_a(partialTicks);
            if (this.visionBuffer != null) {
                this.visionBuffer.func_228471_a_();
            }
        }
    }

    private void adjustVisionShaders(float progress) {
        if (this.blit0 == null) {
            return;
        }
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        this.blit0.func_217624_b().func_216538_b("ColorModulate").func_148081_a(1.0f - 0.4f * progress, 1.0f - 0.5f * progress, 1.0f - 0.3f * progress, 1.0f);
    }

    private void updateFramebufferSize(int width, int height) {
        if (this.blurShader != null) {
            this.blurShader.func_148026_a(width, height);
        }
    }

    private boolean shouldRenderVision() {
        return this.ticks > 0 && this.blurShader != null && this.mc.field_71439_g != null;
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        this.reMakeShader();
    }

    private void reMakeShader() {
        if (this.blurShader != null) {
            this.blurShader.close();
        }
        ResourceLocation resourcelocationBlur = new ResourceLocation("vampirism", "shaders/blank.json");
        try {
            this.blurShader = new ShaderGroup(this.mc.func_110434_K(), this.mc.func_195551_G(), this.mc.func_147110_a(), resourcelocationBlur);
            Framebuffer swap = this.blurShader.func_177066_a("swap");
            this.blit0 = this.blurShader.func_148023_a("blit", swap, this.mc.func_147110_a());
            this.blurShader.func_148026_a(this.mc.func_228018_at_().func_198109_k(), this.mc.func_228018_at_().func_198091_l());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load blood vision blur shader", (Throwable)e);
            this.blurShader = null;
        }
    }
}

