/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import de.teamlapen.lib.lib.client.gui.widget.ScrollableArrayTextComponentList;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.CAppearancePacket;
import de.teamlapen.werewolves.client.render.WerewolfMinionRenderer;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class WerewolfMinionAppearanceScreen
extends AppearanceScreen<WerewolfMinionEntity> {
    private static final ITextComponent NAME = new TranslationTextComponent("gui.vampirism.minion_appearance");
    private int skinType;
    private int eyeType;
    private boolean glowingEyes;
    private ScrollableArrayTextComponentList skinList;
    private ScrollableArrayTextComponentList eyeList;
    private ExtendedButton skinButton;
    private ExtendedButton eyeButton;
    private CheckboxButton glowingEyeButton;
    private TextFieldWidget nameWidget;

    public WerewolfMinionAppearanceScreen(WerewolfMinionEntity entity, @Nullable Screen backScreen) {
        super(NAME, (LivingEntity)entity, backScreen);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.nameWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.guiLeft + 21, this.guiTop + 29, 98, 12, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.name")));
        this.nameWidget.func_146180_a(((WerewolfMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.func_146204_h(-1);
        this.nameWidget.func_146193_g(-1);
        this.nameWidget.func_146203_f(15);
        this.nameWidget.func_212954_a(this::onNameChanged);
        int skinCount = ((WerewolfMinionRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity)).getSkinTextureCount(((WerewolfMinionEntity)this.entity).getForm());
        int eyeCount = ((WerewolfMinionRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity)).getEyeTextureCount(((WerewolfMinionEntity)this.entity).getForm());
        this.eyeType = ((WerewolfMinionEntity)this.entity).getEyeType();
        this.skinType = ((WerewolfMinionEntity)this.entity).getSkinType();
        this.glowingEyes = ((WerewolfMinionEntity)this.entity).hasGlowingEyes();
        this.glowingEyeButton = (CheckboxButton)this.func_230480_a_((Widget)new CheckboxButton(this.guiLeft + 20, this.guiTop + 86, 99, 20, (ITextComponent)new TranslationTextComponent("gui.werewolves.minion_appearance.glowing_eyes"), this.glowingEyes){

            public void func_230930_b_() {
                super.func_230930_b_();
                WerewolfMinionAppearanceScreen.this.glowingEyes = this.func_212942_a();
                ((WerewolfMinionEntity)WerewolfMinionAppearanceScreen.this.entity).setGlowingEyes(WerewolfMinionAppearanceScreen.this.glowingEyes);
            }
        });
        this.skinList = (ScrollableArrayTextComponentList)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80, 20, skinCount, (TextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.skin"), this::setSkinType, this::previewSkin));
        this.eyeList = (ScrollableArrayTextComponentList)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 64 + 19, 99, 60, 20, eyeCount, (TextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.hat"), this::setEyeType, this::previewEye));
        this.skinButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.skinList.field_230690_l_, this.skinList.field_230691_m_ - 20, this.skinList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), b -> this.setSkinListVisibility(!this.skinList.field_230694_p_)));
        this.eyeButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.eyeList.field_230690_l_, this.eyeList.field_230691_m_ - 20, this.eyeList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), b -> this.setHatListVisibility(!this.eyeList.field_230694_p_)));
        this.setSkinListVisibility(false);
        this.setHatListVisibility(false);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.eyeList.func_231045_a_(mouseX, mouseY, button, dragX, dragY) && !this.skinList.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) {
            return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void func_231164_f_() {
        String name = this.nameWidget.func_146179_b();
        if (name.isEmpty()) {
            name = new TranslationTextComponent("text.vampirism.minion").toString() + ((WerewolfMinionEntity)this.entity).getMinionId().orElse(0);
        }
        VampirismMod.dispatcher.sendToServer((IMessage)new CAppearancePacket(((WerewolfMinionEntity)this.entity).func_145782_y(), name, new int[]{this.skinType, this.eyeType, this.glowingEyes ? 1 : 0}));
        super.func_231164_f_();
    }

    private void setEyeType(int type) {
        this.eyeType = type;
        ((WerewolfMinionEntity)this.entity).setEyeType(this.eyeType);
        this.setHatListVisibility(false);
    }

    private void setSkinType(int type) {
        this.skinType = type;
        ((WerewolfMinionEntity)this.entity).setSkinType(this.skinType);
        this.setSkinListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((WerewolfMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewEye(int type, boolean hovered) {
        if (hovered) {
            ((WerewolfMinionEntity)this.entity).setEyeType(type);
        } else if (((WerewolfMinionEntity)this.entity).getEyeType() == type) {
            ((WerewolfMinionEntity)this.entity).setEyeType(this.eyeType);
        }
    }

    private void previewSkin(int type, boolean hovered) {
        if (hovered) {
            ((WerewolfMinionEntity)this.entity).setSkinType(type);
        } else if (((WerewolfMinionEntity)this.entity).getSkinType() == type) {
            ((WerewolfMinionEntity)this.entity).setSkinType(this.skinType);
        }
    }

    private void setHatListVisibility(boolean show) {
        this.eyeButton.func_238482_a_((ITextComponent)this.eyeList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.eyeType + 1)));
        this.eyeList.field_230694_p_ = show;
        boolean bl = this.glowingEyeButton.field_230694_p_ = !show;
        if (show) {
            this.skinList.field_230694_p_ = false;
        }
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.func_238482_a_((ITextComponent)this.skinList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.skinType + 1)));
        this.skinList.field_230694_p_ = show;
        this.eyeButton.field_230694_p_ = !show;
        boolean bl = this.glowingEyeButton.field_230694_p_ = !show;
        if (show) {
            this.eyeList.field_230694_p_ = false;
        }
    }
}

