/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.client.gui.MinionStatsScreen;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WerewolfMinionStatsScreen
extends MinionStatsScreen<WerewolfMinionEntity.WerewolfMinionData, WerewolfMinionEntity> {
    private final TranslationTextComponent inventoryLevel = new TranslationTextComponent("text.vampirism.minion.stats.inventory_level");
    private final TranslationTextComponent healthLevel = new TranslationTextComponent(Attributes.field_233818_a_.func_233754_c_());
    private final TranslationTextComponent strengthLevel = new TranslationTextComponent(Attributes.field_233823_f_.func_233754_c_());
    private final TranslationTextComponent resourceLevel = new TranslationTextComponent("text.vampirism.minion.stats.resource_level");

    public WerewolfMinionStatsScreen(WerewolfMinionEntity entity, @Nullable Screen backScreen) {
        super((MinionEntity)entity, 4, backScreen);
    }

    protected boolean areButtonsVisible(WerewolfMinionEntity.WerewolfMinionData data) {
        return data.getRemainingStatPoints() > 0 || data.getLevel() < 6;
    }

    protected int getRemainingStatPoints(WerewolfMinionEntity.WerewolfMinionData data) {
        return data.getRemainingStatPoints();
    }

    protected boolean isActive(WerewolfMinionEntity.WerewolfMinionData data, int i) {
        switch (i) {
            case 0: {
                return data.getRemainingStatPoints() > 0 && data.getInventoryLevel() < 2;
            }
            case 1: {
                return data.getRemainingStatPoints() > 0 && data.getHealthLevel() < 3;
            }
            case 2: {
                return data.getRemainingStatPoints() > 0 && data.getStrengthLevel() < 3;
            }
            case 3: {
                return data.getRemainingStatPoints() > 0 && data.getResourceEfficiencyLevel() < 2;
            }
        }
        return false;
    }

    protected void renderStats(MatrixStack mStack, WerewolfMinionEntity.WerewolfMinionData data) {
        this.renderLevelRow(mStack, data.getLevel() + 1, 7);
        this.renderStatRow(mStack, 0, this.inventoryLevel, new StringTextComponent("" + data.getInventorySize()), data.getInventoryLevel() + 1, 3);
        this.renderStatRow(mStack, 1, this.healthLevel, new StringTextComponent("" + ((WerewolfMinionEntity)this.entity).func_110148_a(Attributes.field_233818_a_).func_111125_b()), data.getHealthLevel() + 1, 4);
        this.renderStatRow(mStack, 2, this.strengthLevel, new StringTextComponent("" + ((WerewolfMinionEntity)this.entity).func_110148_a(Attributes.field_233823_f_).func_111125_b()), data.getStrengthLevel() + 1, 4);
        this.renderStatRow(mStack, 3, this.resourceLevel, new StringTextComponent("" + (int)Math.ceil((float)(data.getResourceEfficiencyLevel() + 1) / 3.0f * 100.0f) + "%"), data.getResourceEfficiencyLevel() + 1, 3);
    }
}

