/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableArrayTextComponentList;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.client.gui.ScreenModifier;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.network.WerewolfAppearancePacket;
import de.teamlapen.werewolves.util.WerewolfForm;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.tuple.Pair;

public class WerewolfPlayerAppearanceScreen
extends AppearanceScreen<PlayerEntity> {
    private static final ITextComponent NAME = new TranslationTextComponent("gui.vampirism.appearance");
    private final WerewolfPlayer werewolf;
    private WerewolfForm activeForm;
    private int skinType;
    private int eyeType;
    private boolean glowingEyes;
    private boolean renderForm;
    private Button human;
    private Button beast;
    private Button survival;
    private ScrollableListWidget<Pair<Integer, ITextComponent>> eyeList;
    private ScrollableListWidget<Pair<Integer, ITextComponent>> skinList;
    private ExtendedButton eyeButton;
    private ExtendedButton skinButton;
    private CheckboxButton glowingEyesButton;

    public WerewolfPlayerAppearanceScreen(@Nullable Screen backScreen) {
        super(NAME, (LivingEntity)Minecraft.func_71410_x().field_71439_g, backScreen);
        this.werewolf = WerewolfPlayer.get((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public void func_231164_f_() {
        this.updateServer();
        super.func_231164_f_();
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        this.updateServer();
        WerewolfForm form = this.activeForm;
        super.func_231152_a_(minecraft, width, height);
        this.switchToForm(form);
    }

    private void updateServer() {
        WerewolvesMod.dispatcher.sendToServer((IMessage)new WerewolfAppearancePacket(((PlayerEntity)this.entity).func_145782_y(), "", this.activeForm, this.eyeType, this.skinType, this.glowingEyes ? 1 : 0));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        Button.ITooltip notUnlocked = (button, stack, mouseX, mouseY) -> this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("text.werewolves.not_unlocked"), mouseX, mouseY);
        boolean beastUnlocked = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.BEAST_FORM.get());
        boolean survivalUnlocked = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.SURVIVAL_FORM.get());
        this.human = (Button)this.func_230480_a_((Widget)new Button(this.guiLeft + 5, this.guiTop + 20, 67, 20, WerewolfForm.HUMAN.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.HUMAN)));
        this.beast = (Button)this.func_230480_a_((Widget)new Button(this.guiLeft + 71, this.guiTop + 20, 40, 20, WerewolfForm.BEAST.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.BEAST), beastUnlocked ? Button.field_238486_s_ : notUnlocked));
        this.survival = (Button)this.func_230480_a_((Widget)new Button(this.guiLeft + 111, this.guiTop + 20, 55, 20, WerewolfForm.SURVIVALIST.getTextComponent(), button1 -> this.switchToForm(WerewolfForm.SURVIVALIST), survivalUnlocked ? Button.field_238486_s_ : notUnlocked));
        this.switchToForm(WerewolfForm.HUMAN);
    }

    private void sync() {
        boolean beastUnlocked = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.BEAST_FORM.get());
        boolean survivalUnlocked = this.werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.SURVIVAL_FORM.get());
        if (this.activeForm == WerewolfForm.BEAST) {
            this.beast.field_230693_o_ = false;
            this.human.field_230693_o_ = true;
            this.survival.field_230693_o_ = survivalUnlocked;
            this.glowingEyesButton.field_230693_o_ = true;
            this.glowingEyesButton.field_230694_p_ = true;
            this.eyeButton.field_230694_p_ = true;
        } else if (this.activeForm == WerewolfForm.SURVIVALIST) {
            this.beast.field_230693_o_ = beastUnlocked;
            this.human.field_230693_o_ = true;
            this.survival.field_230693_o_ = false;
            this.glowingEyesButton.field_230693_o_ = true;
            this.glowingEyesButton.field_230694_p_ = true;
            this.eyeButton.field_230694_p_ = true;
        } else {
            this.beast.field_230693_o_ = beastUnlocked;
            this.human.field_230693_o_ = false;
            this.survival.field_230693_o_ = survivalUnlocked;
            this.glowingEyesButton.field_230693_o_ = false;
            this.glowingEyesButton.field_230694_p_ = false;
            this.eyeButton.field_230694_p_ = false;
        }
    }

    private void switchToForm(WerewolfForm form) {
        if (this.eyeButton != null) {
            ((ScreenModifier)((Object)this)).removeButton(this.eyeButton);
            ((ScreenModifier)((Object)this)).removeButton(this.skinButton);
            ((ScreenModifier)((Object)this)).removeButton(this.eyeList);
            ((ScreenModifier)((Object)this)).removeButton(this.skinList);
            ((ScreenModifier)((Object)this)).removeButton(this.glowingEyesButton);
        }
        if (this.activeForm != null) {
            this.updateServer();
        }
        this.activeForm = form;
        this.skinType = this.werewolf.getSkinType(form);
        this.eyeType = this.werewolf.getEyeType(form);
        this.glowingEyes = this.werewolf.hasGlowingEyes(form);
        this.eyeList = (ScrollableListWidget)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 30 + 19 + 20, 99, 100, 20, 6, (TextComponent)new TranslationTextComponent("text.werewolves.appearance.eye"), this::eye, this::hoverEye));
        this.skinList = (ScrollableListWidget)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 50 + 19 + 20, 99, 80, 20, form.getSkinTypes(), (TextComponent)new TranslationTextComponent("text.werewolves.appearance.skin"), this::skin, this::hoverSkin));
        this.eyeButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.eyeList.field_230690_l_, this.eyeList.field_230691_m_ - 20, this.eyeList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), b -> this.setEyeListVisibility(!this.eyeList.field_230694_p_)));
        this.skinButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.skinList.field_230690_l_, this.skinList.field_230691_m_ - 20, this.skinList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), b -> this.setSkinListVisibility(!this.skinList.field_230694_p_)));
        this.glowingEyesButton = (CheckboxButton)this.func_230480_a_((Widget)new CheckboxButton(this.guiLeft + 20, this.guiTop + 90, 99, 20, (ITextComponent)new TranslationTextComponent("gui.vampirism.appearance.glowing_eye"), this.glowingEyes){

            public void func_230930_b_() {
                super.func_230930_b_();
                WerewolfPlayerAppearanceScreen.this.glowingEyes = this.func_212942_a();
                WerewolfPlayerAppearanceScreen.this.werewolf.setGlowingEyes(WerewolfPlayerAppearanceScreen.this.activeForm, WerewolfPlayerAppearanceScreen.this.glowingEyes);
            }
        });
        this.setEyeListVisibility(false);
        this.setSkinListVisibility(false);
        this.sync();
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.renderForm = true;
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.eyeList.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.skinList.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.renderForm = false;
    }

    public boolean isRenderForm() {
        return this.renderForm;
    }

    public WerewolfForm getActiveForm() {
        return this.activeForm;
    }

    private void setEyeListVisibility(boolean show) {
        this.eyeButton.func_238482_a_((ITextComponent)this.eyeList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.eyeType + 1)));
        this.eyeList.field_230694_p_ = show;
        boolean bl = this.skinButton.field_230694_p_ = !show;
        if (show) {
            this.skinList.field_230694_p_ = false;
        }
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.func_238482_a_((ITextComponent)this.skinList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.skinType + 1)));
        this.skinList.field_230694_p_ = show;
        if (show) {
            this.eyeList.field_230694_p_ = false;
        }
    }

    private void eye(int eyeType) {
        this.eyeType = eyeType;
        this.werewolf.setEyeType(this.activeForm, eyeType);
        this.setEyeListVisibility(false);
    }

    private void skin(int skinType) {
        this.skinType = skinType;
        this.werewolf.setSkinType(this.activeForm, skinType);
        this.setSkinListVisibility(false);
    }

    private void hoverEye(int eyeType, boolean hovered) {
        if (hovered) {
            this.werewolf.setEyeType(this.activeForm, eyeType);
        } else if (this.werewolf.getEyeType() == eyeType) {
            this.werewolf.setEyeType(this.activeForm, this.eyeType);
        }
    }

    private void hoverSkin(int skintype, boolean hovered) {
        if (hovered) {
            this.werewolf.setSkinType(this.activeForm, skintype);
        } else if (this.werewolf.getSkinType() == skintype) {
            this.werewolf.setSkinType(this.activeForm, this.skinType);
        }
    }
}

