/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.client.model.WerewolfBeastModel;
import de.teamlapen.werewolves.client.model.WerewolfEarsModel;
import de.teamlapen.werewolves.client.model.WerewolfSurvivalistModel;
import de.teamlapen.werewolves.client.render.WerewolfModelWrapper;
import de.teamlapen.werewolves.client.render.layer.WerewolfFormFaceOverlayLayer;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public abstract class BaseWerewolfRenderer<T extends LivingEntity>
extends LivingRenderer<T, WerewolfBaseModel<T>> {
    private final Map<WerewolfForm, WerewolfModelWrapper<T>> models = new HashMap<WerewolfForm, WerewolfModelWrapper<T>>();
    protected final ResourceLocation[] eyeOverlays;
    protected List<ResourceLocation> textures;
    protected WerewolfForm form = WerewolfForm.NONE;

    public BaseWerewolfRenderer(EntityRendererManager rendererManager, float size) {
        super(rendererManager, null, 0.0f);
        this.eyeOverlays = new ResourceLocation[6];
        for (int i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("werewolves:textures/entity/werewolf/eye/eye_" + i + ".png");
        }
        this.models.put(WerewolfForm.NONE, new WerewolfModelWrapper(() -> null, null, 0.0f, false));
        this.models.put(WerewolfForm.HUMAN, new WerewolfModelWrapper(WerewolfEarsModel::new, renderer -> Collections.emptyList(), WerewolfModelWrapper::getHumanTextures, size, false));
        this.models.put(WerewolfForm.BEAST, new WerewolfModelWrapper(WerewolfBeastModel::new, renderer -> Collections.singleton(new WerewolfFormFaceOverlayLayer(WerewolfForm.BEAST, renderer, this.eyeOverlays)), WerewolfModelWrapper::getBeastTextures, 2.6f * size, true));
        this.models.put(WerewolfForm.SURVIVALIST, new WerewolfModelWrapper(WerewolfSurvivalistModel::new, renderer -> Collections.singleton(new WerewolfFormFaceOverlayLayer(WerewolfForm.SURVIVALIST, renderer, this.eyeOverlays)), WerewolfModelWrapper::getSurvivalTextures, size, true));
        this.models.forEach((a, b) -> b.refresh(this));
    }

    public void switchModel(WerewolfForm type) {
        if (this.form == type) {
            return;
        }
        this.form = type;
        WerewolfModelWrapper<T> werewolfModelWrapper = this.getWrapper(type);
        this.field_77045_g = werewolfModelWrapper.getModel();
        this.field_76989_e = werewolfModelWrapper.shadow;
        this.textures = werewolfModelWrapper.textures;
        this.field_177097_h.clear();
        this.field_177097_h.addAll(werewolfModelWrapper.getLayers());
    }

    protected WerewolfModelWrapper<T> getWrapper(WerewolfForm type) {
        return this.models.get(type);
    }

    protected void func_225621_a_(@Nonnull T entityLiving, @Nonnull MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        if (entityLiving.func_205015_b(partialTicks) > 0.0f && this.form.isHumanLike()) {
            float f3 = entityLiving.func_70090_H() ? -90.0f - ((LivingEntity)entityLiving).field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)entityLiving.func_205015_b(partialTicks), (float)0.0f, (float)f3);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
            if (entityLiving.func_213314_bj()) {
                matrixStackIn.func_227861_a_(0.0, -1.0, (double)0.3f);
            }
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull T entity) {
        return this.textures.get(Helper.asIWerewolf(entity).getSkinType(this.form) % this.form.getSkinTypes());
    }
}

