/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WerewolfModelWrapper<T extends LivingEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private WerewolfBaseModel<T> model;
    private Collection<LayerRenderer<T, WerewolfBaseModel<T>>> layers;
    public List<ResourceLocation> textures;
    public final Supplier<WerewolfBaseModel<T>> modelSupplier;
    private final Function<LivingRenderer<T, WerewolfBaseModel<T>>, Collection<LayerRenderer<T, WerewolfBaseModel<T>>>> layersFactory;
    public final Supplier<List<ResourceLocation>> texturesSupplier;
    public final float shadow;
    public final boolean skipPlayerModel;

    public WerewolfModelWrapper(Supplier<WerewolfBaseModel<T>> model, Function<LivingRenderer<T, WerewolfBaseModel<T>>, Collection<LayerRenderer<T, WerewolfBaseModel<T>>>> layersFactory, Supplier<List<ResourceLocation>> texturesSupplier, float shadow, boolean skipPlayerModel) {
        this.modelSupplier = model;
        this.texturesSupplier = texturesSupplier;
        this.shadow = shadow;
        this.skipPlayerModel = skipPlayerModel;
        this.layersFactory = layersFactory;
    }

    public WerewolfModelWrapper(Supplier<WerewolfBaseModel<T>> model, Function<LivingRenderer<T, WerewolfBaseModel<T>>, Collection<LayerRenderer<T, WerewolfBaseModel<T>>>> layersFactory, ResourceLocation texture, float shadow, boolean skipPlayerModel) {
        this(model, layersFactory, () -> Collections.singletonList(texture), shadow, skipPlayerModel);
    }

    public WerewolfModelWrapper(Supplier<WerewolfBaseModel<T>> model, ResourceLocation textures, float shadow, boolean skipPlayerModel) {
        this(model, (LivingRenderer<T, WerewolfBaseModel<T>> a) -> Collections.emptyList(), () -> Collections.singletonList(textures), shadow, skipPlayerModel);
    }

    public void refresh(LivingRenderer<T, WerewolfBaseModel<T>> renderer) {
        this.layers = Collections.unmodifiableCollection(this.layersFactory.apply(renderer));
        this.model = this.modelSupplier.get();
        this.textures = this.texturesSupplier.get();
    }

    public Collection<LayerRenderer<T, WerewolfBaseModel<T>>> getLayers() {
        return this.layers;
    }

    public WerewolfBaseModel<T> getModel() {
        return this.model;
    }

    public static List<ResourceLocation> getBeastTextures() {
        List<ResourceLocation> locs = Minecraft.func_71410_x().func_195551_G().func_199003_a("textures/entity/werewolf/beast", s -> s.endsWith(".png")).stream().filter(r -> "werewolves".equals(r.func_110624_b())).collect(Collectors.toList());
        if (locs.size() < WerewolfForm.BEAST.getSkinTypes()) {
            LOGGER.error("Could not find all textures for the beast werewolf form");
            for (int i = 0; i < WerewolfForm.BEAST.getSkinTypes(); ++i) {
                ResourceLocation s2 = new ResourceLocation("werewolves", "textures/entity/werewolf/beast/beast_" + i + ".png");
                if (locs.contains(s2)) continue;
                locs.add(s2);
            }
        }
        return locs;
    }

    public static List<ResourceLocation> getSurvivalTextures() {
        List<ResourceLocation> locs = Minecraft.func_71410_x().func_195551_G().func_199003_a("textures/entity/werewolf/survivalist", s -> s.endsWith(".png")).stream().filter(r -> "werewolves".equals(r.func_110624_b())).collect(Collectors.toList());
        if (locs.size() < WerewolfForm.SURVIVALIST.getSkinTypes()) {
            LOGGER.error("Could not find all textures for the survivalist werewolf form");
            for (int i = 0; i < WerewolfForm.SURVIVALIST.getSkinTypes(); ++i) {
                ResourceLocation s2 = new ResourceLocation("werewolves", "textures/entity/werewolf/survivalist/survivalist_" + i + ".png");
                if (locs.contains(s2)) continue;
                locs.add(s2);
            }
        }
        return locs;
    }

    public static List<ResourceLocation> getHumanTextures() {
        List<ResourceLocation> locs = Minecraft.func_71410_x().func_195551_G().func_199003_a("textures/entity/werewolf/human", s -> s.endsWith(".png")).stream().filter(r -> "werewolves".equals(r.func_110624_b())).collect(Collectors.toList());
        if (locs.size() < WerewolfForm.HUMAN.getSkinTypes()) {
            LOGGER.error("Could not find all textures for the human werewolf form");
            for (int i = 0; i < WerewolfForm.HUMAN.getSkinTypes(); ++i) {
                ResourceLocation s2 = new ResourceLocation("werewolves", "textures/entity/werewolf/human/werewolf_ear_claws_" + i + ".png");
                if (locs.contains(s2)) continue;
                locs.add(s2);
            }
        }
        return locs;
    }
}

