/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.werewolves.client.gui.WerewolfPlayerAppearanceScreen;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.client.render.BaseWerewolfRenderer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.WerewolfForm;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WerewolfPlayerRenderer
extends BaseWerewolfRenderer<AbstractClientPlayerEntity> {
    private boolean skipPlayerModel;

    public WerewolfPlayerRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, 0.5f);
    }

    @Override
    public void switchModel(WerewolfForm type) {
        if (this.form == type) {
            return;
        }
        super.switchModel(type);
        this.skipPlayerModel = this.getWrapper((WerewolfForm)type).skipPlayerModel;
    }

    private void setModelVisible(@Nonnull AbstractClientPlayerEntity clientPlayer) {
        WerewolfBaseModel playerModel = (WerewolfBaseModel)this.func_217764_d();
        if (clientPlayer.func_175149_v()) {
            playerModel.func_178719_a(false);
            playerModel.field_78116_c.field_78806_j = true;
        } else {
            playerModel.func_178719_a(true);
            playerModel.field_228270_o_ = clientPlayer.func_213453_ef();
        }
    }

    public boolean renderRightArm(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn) {
        WerewolfForm form = WerewolfPlayer.get((PlayerEntity)playerIn).getForm();
        if (!form.isHumanLike()) {
            form = WerewolfForm.BEAST;
        }
        this.switchModel(form);
        ModelRenderer arm = ((WerewolfBaseModel)this.func_217764_d()).getRightArmModel();
        if (arm != null) {
            if (this.shouldRenderArm(HandSide.RIGHT, playerIn)) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227862_a_(1.2f, 1.0f, 1.2f);
                matrixStackIn.func_227861_a_(0.0, 0.2, 0.4);
                this.renderItem(matrixStackIn, bufferIn, combinedLightIn, playerIn, arm);
                matrixStackIn.func_227865_b_();
            } else {
                return false;
            }
        }
        return !form.isHumanLike();
    }

    public boolean renderLeftArm(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn) {
        WerewolfForm form = WerewolfPlayer.get((PlayerEntity)playerIn).getForm();
        if (!form.isHumanLike()) {
            form = WerewolfForm.BEAST;
        }
        this.switchModel(form);
        ModelRenderer arm = ((WerewolfBaseModel)this.func_217764_d()).getLeftArmModel();
        if (arm != null) {
            if (this.shouldRenderArm(HandSide.LEFT, playerIn)) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227862_a_(1.2f, 1.0f, 1.2f);
                matrixStackIn.func_227861_a_(0.0, 0.2, 0.4);
                this.renderItem(matrixStackIn, bufferIn, combinedLightIn, playerIn, arm);
                matrixStackIn.func_227865_b_();
            } else {
                return false;
            }
        }
        return !form.isHumanLike();
    }

    private boolean shouldRenderArm(HandSide armSide, @Nonnull AbstractClientPlayerEntity player) {
        HandSide side = player.func_184591_cq();
        ItemStack mainStack = player.func_184586_b(Hand.MAIN_HAND);
        ItemStack offStack = player.func_184586_b(Hand.OFF_HAND);
        if (armSide == side) {
            return mainStack.func_77973_b() != Items.field_151098_aY;
        }
        return offStack.func_77973_b() != Items.field_151098_aY && (!offStack.func_190926_b() || mainStack.func_77973_b() != Items.field_151098_aY);
    }

    private void renderItem(MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn, @Nonnull ModelRenderer rendererArmIn) {
        WerewolfBaseModel model = (WerewolfBaseModel)this.func_217764_d();
        this.setModelVisible(playerIn);
        model.field_217112_c = 0.0f;
        model.field_228270_o_ = false;
        model.field_205061_a = 0.0f;
        rendererArmIn.func_228308_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.getTextureLocation(playerIn))), combinedLightIn, OverlayTexture.field_229196_a_);
    }

    public boolean render(@Nonnull WerewolfPlayer entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        WerewolfForm form = entity.getForm();
        if (Minecraft.func_71410_x().field_71462_r instanceof WerewolfPlayerAppearanceScreen) {
            form = ((WerewolfPlayerAppearanceScreen)Minecraft.func_71410_x().field_71462_r).getActiveForm();
        }
        this.switchModel(form);
        if (this.field_77045_g != null && this.skipPlayerModel) {
            this.render((AbstractClientPlayerEntity)entity.getRepresentingPlayer(), entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            return true;
        }
        return false;
    }

    public void renderPost(PlayerModel<AbstractClientPlayerEntity> entityModel, WerewolfPlayer entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (this.field_77045_g != null && !this.skipPlayerModel) {
            ((WerewolfBaseModel)this.field_77045_g).setPlayerModel(entityModel);
            this.render((AbstractClientPlayerEntity)entity.getRepresentingPlayer(), entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    @Deprecated
    public void render(@Nonnull AbstractClientPlayerEntity entity, float entityYaw, float partialTicks, @Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!entity.func_175144_cb() || this.field_76990_c.field_217783_c.func_216773_g() == entity) {
            this.setModelVisible(entity);
            super.func_225623_a_((LivingEntity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    public WerewolfForm getForm() {
        return this.form;
    }
}

