/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class WerewolfEntityFaceOverlayLayer<T extends WerewolfBaseEntity, M extends WerewolfBaseModel<T>>
extends LayerRenderer<T, M> {
    private final ResourceLocation[] eyeOverlays = new ResourceLocation[6];

    public WerewolfEntityFaceOverlayLayer(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
        for (int i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("werewolves:textures/entity/werewolf/eye/eye_" + i + ".png");
        }
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn, @Nonnull WerewolfBaseEntity werewolf, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int s = werewolf.getEyeType();
        int eyeType = Math.max(0, s) % this.eyeOverlays.length;
        RenderType renderType = RenderType.func_228652_i_((ResourceLocation)this.eyeOverlays[eyeType]);
        IVertexBuilder vertexBuilderEye = bufferIn.getBuffer(renderType);
        int packerOverlay = LivingRenderer.func_229117_c_((LivingEntity)werewolf, (float)0.0f);
        ((WerewolfBaseModel)this.func_215332_c()).getModelRenderer().func_228308_a_(matrixStack, vertexBuilderEye, packedLightIn, packerOverlay);
    }
}

