/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.IWerewolf;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class WerewolfFaceOverlayLayer<T extends LivingEntity>
extends LayerRenderer<T, WerewolfBaseModel<T>> {
    private final ResourceLocation[] eyeOverlays;

    public WerewolfFaceOverlayLayer(LivingRenderer<T, WerewolfBaseModel<T>> renderer, ResourceLocation[] overlays) {
        super(renderer);
        this.eyeOverlays = overlays;
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn, @Nonnull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IWerewolf werewolf = entity instanceof IWerewolf ? (IWerewolf)entity : WerewolfPlayer.get((PlayerEntity)entity);
        int eyeType = Math.max(0, Math.min(this.getEyeType(werewolf), this.eyeOverlays.length - 1));
        RenderType renderType = this.hasGlowingEyes(werewolf) ? RenderType.func_228652_i_((ResourceLocation)this.eyeOverlays[eyeType]) : RenderType.func_228640_c_((ResourceLocation)this.eyeOverlays[eyeType]);
        IVertexBuilder vertexBuilderEye = bufferIn.getBuffer(renderType);
        int packerOverlay = LivingRenderer.func_229117_c_(entity, (float)0.0f);
        ((WerewolfBaseModel)this.func_215332_c()).getModelRenderer().func_228308_a_(matrixStack, vertexBuilderEye, packedLightIn, packerOverlay);
    }

    public int getEyeType(IWerewolf werewolf) {
        return werewolf.getEyeType();
    }

    public boolean hasGlowingEyes(IWerewolf werewolf) {
        return werewolf.hasGlowingEyes();
    }
}

