/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.werewolves.command.arguments.WerewolfFormArgument;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.util.WReference;
import de.teamlapen.werewolves.util.WerewolfForm;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.StringTextComponent;

public class MinionCommand
extends BasicCommand {
    private static final DynamicCommandExceptionType fail = new DynamicCommandExceptionType(msg -> new StringTextComponent("Failed: " + msg));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"minion").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"spawnNew").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"werewolf").executes(context -> MinionCommand.spawnNewWerewolfMinion((CommandSource)context.getSource(), "Minion", 0, 0, false, WerewolfForm.BEAST))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> MinionCommand.spawnNewWerewolfMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), 0, 0, false, WerewolfForm.BEAST))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"skinType", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MinionCommand.spawnNewWerewolfMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"skinType"), 0, false, WerewolfForm.BEAST))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"eyeType", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MinionCommand.spawnNewWerewolfMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"skinType"), IntegerArgumentType.getInteger((CommandContext)context, (String)"eyeType"), false, WerewolfForm.BEAST))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"glowingEye", (ArgumentType)BoolArgumentType.bool()).executes(context -> MinionCommand.spawnNewWerewolfMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"skinType"), IntegerArgumentType.getInteger((CommandContext)context, (String)"eyeType"), BoolArgumentType.getBool((CommandContext)context, (String)"glowingEye"), WerewolfForm.BEAST))).then(Commands.func_197056_a((String)"form", (ArgumentType)WerewolfFormArgument.nonHumanForms()).executes(context -> MinionCommand.spawnNewWerewolfMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"skinType"), IntegerArgumentType.getInteger((CommandContext)context, (String)"eyeType"), BoolArgumentType.getBool((CommandContext)context, (String)"glowingEye"), WerewolfFormArgument.getForm((CommandContext<CommandSource>)context, "form"))))))))));
    }

    private static int spawnNewWerewolfMinion(CommandSource ctx, String name, int skinType, int eyeType, boolean glowingEyes, WerewolfForm form) throws CommandSyntaxException {
        WerewolfMinionEntity.WerewolfMinionData data = new WerewolfMinionEntity.WerewolfMinionData(name, skinType, eyeType, glowingEyes, form);
        return MinionCommand.spawnNewMinion(ctx, WReference.WEREWOLF_FACTION, data, (EntityType)ModEntities.WEREWOLF_MINION.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends MinionData> int spawnNewMinion(CommandSource ctx, IPlayableFaction<?> faction, T data, EntityType<? extends MinionEntity<T>> type) throws CommandSyntaxException {
        ServerPlayerEntity p = ctx.func_197035_h();
        FactionPlayerHandler fph = FactionPlayerHandler.get((PlayerEntity)p);
        if (fph.getMaxMinions() <= 0) throw fail.create((Object)"Can't have minions");
        PlayerMinionController controller = MinionWorldData.getData((MinecraftServer)ctx.func_197028_i()).getOrCreateController(fph);
        if (!controller.hasFreeMinionSlot()) throw fail.create((Object)"No free slot");
        if (fph.getCurrentFaction() != faction) throw fail.create((Object)"Wrong faction");
        int id = controller.createNewMinionSlot(data, type);
        if (id < 0) {
            throw fail.create((Object)"Failed to get new minion slot");
        }
        controller.createMinionEntityAtPlayer(id, (PlayerEntity)p);
        return 0;
    }
}

