/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.world.WerewolfHeavenBiome;
import de.teamlapen.werewolves.world.WerewolvesBiomeFeatures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"werewolves");
    public static final RegistryKey<Biome> WEREWOLF_HEAVEN_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("werewolves", "werewolf_heaven"));
    public static final RegistryObject<Biome> WEREWOLF_HEAVEN = BIOMES.register("werewolf_heaven", WerewolfHeavenBiome::createWerewolfHeavenBiome);

    static void registerBiomes(IEventBus bus) {
        BIOMES.register(bus);
        BiomeDictionary.addTypes(WEREWOLF_HEAVEN_KEY, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.HILLS});
    }

    static void removeStructuresFromBiomes() {
        VampirismAPI.worldGenRegistry().removeStructureFromBiomes(ModFeatures.HUNTER_CAMP.getId(), (List)Lists.newArrayList((Object[])new ResourceLocation[]{WEREWOLF_HEAVEN_KEY.func_240901_a_()}));
    }

    static void addBiomesToGeneratorUnsafe() {
        if (!((Boolean)WerewolvesConfig.COMMON.disableWerewolfHeaven.get()).booleanValue()) {
            ArrayList<RegistryKey<Biome>> modlist = new ArrayList<RegistryKey<Biome>>(OverworldBiomeProvider.field_226847_e_);
            modlist.add(WEREWOLF_HEAVEN_KEY);
            OverworldBiomeProvider.field_226847_e_ = ImmutableList.copyOf(modlist);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(WEREWOLF_HEAVEN_KEY, ((Integer)WerewolvesConfig.COMMON.werewolfHeavenWeight.get()).intValue()));
        }
    }

    public static void onBiomeLoadingEventAdditions(BiomeLoadingEvent event) {
        if (!((Boolean)WerewolvesConfig.COMMON.disableOreGen.get()).booleanValue() && event.getCategory() != Biome.Category.THEEND && event.getCategory() != Biome.Category.NETHER) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, WerewolvesBiomeFeatures.silver_ore);
        }
        if (event.getCategory() == Biome.Category.FOREST) {
            WerewolvesBiomeFeatures.addWerewolvesFlowers((BiomeGenerationSettings.Builder)event.getGeneration());
        }
        if (event.getCategory() == Biome.Category.TAIGA) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)ModEntities.HUMAN_WEREWOLF.get(), 5, 1, 1));
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)ModEntities.WEREWOLF_SURVIVALIST.get(), 80, 1, 2));
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)ModEntities.WEREWOLF_BEAST.get(), 80, 1, 2));
        }
    }
}

