/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import com.google.common.collect.ImmutableSet;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.entities.AggressiveWolfEntity;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.HumanWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfAlphaEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTaskMasterEntity;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"werewolves");
    public static final RegistryObject<EntityType<BasicWerewolfEntity.Beast>> WEREWOLF_BEAST = ENTITIES.register("werewolf_beast", () -> ModEntities.prepareEntityType("werewolf_beast", EntityType.Builder.func_220322_a(BasicWerewolfEntity.Beast::new, (EntityClassification)WerewolvesMod.WEREWOLF_CREATURE_TYPE).func_220321_a(0.8f, 2.0f), true));
    public static final RegistryObject<EntityType<BasicWerewolfEntity.Survivalist>> WEREWOLF_SURVIVALIST = ENTITIES.register("werewolf_survivalist", () -> ModEntities.prepareEntityType("werewolf_survivalist", EntityType.Builder.func_220322_a(BasicWerewolfEntity.Survivalist::new, (EntityClassification)WerewolvesMod.WEREWOLF_CREATURE_TYPE).func_220321_a(0.8f, 1.0f), true));
    public static final RegistryObject<EntityType<HumanWerewolfEntity>> HUMAN_WEREWOLF = ENTITIES.register("human_werewolf", () -> ModEntities.prepareEntityType("human_werewolf", EntityType.Builder.func_220322_a(HumanWerewolfEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.9f), true));
    public static final RegistryObject<EntityType<WerewolfTaskMasterEntity>> TASK_MASTER_WEREWOLF = ENTITIES.register("task_master_werewolf", () -> ModEntities.prepareEntityType("task_master_werewolf", EntityType.Builder.func_220322_a(WerewolfTaskMasterEntity::new, (EntityClassification)WerewolvesMod.WEREWOLF_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<AggressiveWolfEntity>> WOLF = ENTITIES.register("wolf", () -> ModEntities.prepareEntityType("wolf", EntityType.Builder.func_220322_a(AggressiveWolfEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.6f, 0.85f), false));
    public static final RegistryObject<EntityType<WerewolfMinionEntity>> WEREWOLF_MINION = ENTITIES.register("werewolf_minion", () -> ModEntities.prepareEntityType("werewolf_minion", EntityType.Builder.func_220322_a(WerewolfMinionEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f), false));
    public static final RegistryObject<EntityType<WerewolfAlphaEntity>> ALPHA_WEREWOLF = ENTITIES.register("alpha_werewolf", () -> ModEntities.prepareEntityType("alpha_werewolf", EntityType.Builder.func_220322_a(WerewolfAlphaEntity::new, (EntityClassification)WerewolvesMod.WEREWOLF_CREATURE_TYPE).func_220321_a(0.8f, 2.0f), true));

    static void registerEntities(IEventBus bus) {
        ENTITIES.register(bus);
    }

    static void initializeEntities() {
        WerewolfMinionEntity.registerMinionData();
    }

    static void registerSpawns() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WEREWOLF_BEAST.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, WerewolfBaseEntity::spawnPredicateWerewolf);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WEREWOLF_SURVIVALIST.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, WerewolfBaseEntity::spawnPredicateWerewolf);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)HUMAN_WEREWOLF.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HumanWerewolfEntity::spawnPredicateHumanWerewolf);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WOLF.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (entityType, world, spawnReason, blockPos, random) -> true);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ALPHA_WEREWOLF.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, WerewolfAlphaEntity::spawnPredicateAlpha);
    }

    private static <T extends Entity> EntityType<T> prepareEntityType(String id, EntityType.Builder<T> builder, boolean spawnable) {
        EntityType.Builder type = builder.setTrackingRange(10).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
        if (!spawnable) {
            type.func_200705_b();
        }
        return type.func_206830_a("werewolves:" + id);
    }

    static void onRegisterEntityTypeAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HUMAN_WEREWOLF.get(), HumanWerewolfEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)WEREWOLF_BEAST.get(), BasicWerewolfEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)WEREWOLF_SURVIVALIST.get(), BasicWerewolfEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)WOLF.get(), AggressiveWolfEntity.func_234233_eS_().func_233813_a_());
        event.put((EntityType)TASK_MASTER_WEREWOLF.get(), WerewolfTaskMasterEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)WEREWOLF_MINION.get(), WerewolfMinionEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)ALPHA_WEREWOLF.get(), WerewolfAlphaEntity.getAttributeBuilder().func_233813_a_());
    }

    static void onModifyEntityTypeAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.field_200729_aH, (Attribute)ModAttributes.BITE_DAMAGE.get());
        event.add(EntityType.field_200729_aH, (Attribute)ModAttributes.TIME_REGAIN.get());
    }

    public static Set<EntityType<?>> getAllEntities() {
        return ImmutableSet.copyOf((Collection)ENTITIES.getEntries().stream().flatMap(RegistryObject::stream).collect(Collectors.toList()));
    }

    static {
        V.init();
    }

    public static class V {
        public static final RegistryObject<EntityType<BasicHunterEntity>> HUNTER = RegistryObject.of((ResourceLocation)new ResourceLocation("vampirism", "hunter"), (IForgeRegistry)ForgeRegistries.ENTITIES);
        public static final RegistryObject<EntityType<BasicHunterEntity.IMob>> HUNTER_IMOB = RegistryObject.of((ResourceLocation)new ResourceLocation("vampirism", "hunter_imob"), (IForgeRegistry)ForgeRegistries.ENTITIES);

        private static void init() {
        }
    }
}

