/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import com.google.common.collect.Maps;
import de.teamlapen.werewolves.world.loot.MobLootModifier;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModLootTables {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"werewolves");
    private static final Map<ResourceLocation, ResourceLocation> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceLocation villager = ModLootTables.entity(EntityType.field_200756_av);
    public static final ResourceLocation skeleton = ModLootTables.entity(EntityType.field_200741_ag);
    public static final ResourceLocation abandoned_mineshaft = ModLootTables.chest("abandoned_mineshaft");
    public static final ResourceLocation jungle_temple = ModLootTables.chest("jungle_temple");
    public static final ResourceLocation stronghold_corridor = ModLootTables.chest("stronghold_corridor");
    public static final ResourceLocation desert_pyramid = ModLootTables.chest("desert_pyramid");
    public static final ResourceLocation stronghold_library = ModLootTables.chest("stronghold_library");
    public static final RegistryObject<GlobalLootModifierSerializer<MobLootModifier>> MOB_MODIFIER = LOOT_MODIFIER_SERIALIZERS.register("mob_modifier", MobLootModifier.ModLootModifierSerializer::new);

    static void registerLootModifier(IEventBus bus) {
        LOOT_MODIFIER_SERIALIZERS.register(bus);
    }

    static ResourceLocation entity(EntityType<?> type) {
        ResourceLocation loc = type.func_220348_g();
        ResourceLocation newLoc = new ResourceLocation("werewolves", "inject/entity/" + loc.func_110623_a());
        INJECTION_TABLES.put(loc, newLoc);
        return newLoc;
    }

    static ResourceLocation chest(String chest) {
        ResourceLocation loc = new ResourceLocation("chests/" + chest);
        ResourceLocation newLoc = new ResourceLocation("werewolves", "inject/chest/" + chest);
        INJECTION_TABLES.put(loc, newLoc);
        return newLoc;
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (INJECTION_TABLES.containsKey(event.getName())) {
            try {
                event.getTable().addPool(ModLootTables.getInjectPool(event.getName()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private static LootPool getInjectPool(ResourceLocation loc) {
        TableLootEntry.func_216171_a((ResourceLocation)INJECTION_TABLES.get(loc)).func_216086_a(1);
        return LootPool.func_216096_a().name("werewolves_inject_pool").bonusRolls(0.0f, 1.0f).func_216046_a((IRandomRange)new RandomValueRange(1.0f)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)INJECTION_TABLES.get(loc)).func_216086_a(1)).func_216044_b();
    }
}

